/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.oauth.serviceprovider;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.user.UserRenamedEvent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.oauth.serviceprovider.ServiceProviderToken;
import com.atlassian.oauth.serviceprovider.ServiceProviderTokenStore;
import com.atlassian.oauth.serviceprovider.StoreException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class CachingServiceProviderTokenStore
implements ServiceProviderTokenStore,
InitializingBean,
DisposableBean {
    private final Cache<String, CacheObject<ServiceProviderToken>> cache;
    private ServiceProviderTokenStore delegateStore;
    private final EventPublisher eventPublisher;

    public CachingServiceProviderTokenStore(ServiceProviderTokenStore delegateStore, EventPublisher eventPublisher, CacheManager cacheManager) {
        this.delegateStore = delegateStore;
        this.eventPublisher = eventPublisher;
        this.cache = cacheManager.getCache(CachingServiceProviderTokenStore.class.getName() + ".cache", (CacheLoader)new TokenCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(4000).build());
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void clearCaches(ClearCacheEvent event) {
        this.cache.removeAll();
    }

    @EventListener
    public void onUserRenamed(UserRenamedEvent event) {
        this.cache.removeAll();
    }

    public ServiceProviderToken get(String token) throws StoreException {
        Assertions.notNull((String)"token", (Object)token);
        return (ServiceProviderToken)((CacheObject)this.cache.get((Object)token)).getValue();
    }

    public Iterable<ServiceProviderToken> getAccessTokensForUser(String username) {
        return this.delegateStore.getAccessTokensForUser(username);
    }

    public ServiceProviderToken put(ServiceProviderToken token) throws StoreException {
        Assertions.notNull((String)"token", (Object)token);
        try {
            ServiceProviderToken serviceProviderToken = this.delegateStore.put(token);
            return serviceProviderToken;
        }
        finally {
            this.cache.remove((Object)token.toString());
        }
    }

    public void removeAndNotify(String token) throws StoreException {
        Assertions.notNull((String)"token", (Object)token);
        try {
            this.delegateStore.removeAndNotify(token);
        }
        finally {
            this.cache.remove((Object)token);
        }
    }

    public void removeExpiredTokensAndNotify() throws StoreException {
        try {
            this.delegateStore.removeExpiredTokensAndNotify();
        }
        finally {
            this.cache.removeAll();
        }
    }

    public void removeExpiredSessionsAndNotify() throws StoreException {
        try {
            this.delegateStore.removeExpiredSessionsAndNotify();
        }
        finally {
            this.cache.removeAll();
        }
    }

    public void removeByConsumer(String consumerKey) {
        try {
            this.delegateStore.removeByConsumer(consumerKey);
        }
        finally {
            this.cache.removeAll();
        }
    }

    private class TokenCacheLoader
    implements CacheLoader<String, CacheObject<ServiceProviderToken>> {
        private TokenCacheLoader() {
        }

        public CacheObject<ServiceProviderToken> load(String key) {
            return CacheObject.wrap((Object)CachingServiceProviderTokenStore.this.delegateStore.get(key));
        }
    }
}

