/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.oauth.serviceprovider;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.oauth.serviceprovider.StoreException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class CachingServiceProviderConsumerStore
implements ServiceProviderConsumerStore,
InitializingBean,
DisposableBean {
    private final Cache<String, CacheObject<Consumer>> cache;
    private ServiceProviderConsumerStore delegateStore;
    private final EventPublisher eventPublisher;

    public CachingServiceProviderConsumerStore(ServiceProviderConsumerStore delegateStore, EventPublisher eventPublisher, CacheManager cacheManager) {
        this.eventPublisher = eventPublisher;
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.delegateStore = delegateStore;
        this.cache = cacheManager.getCache(CachingServiceProviderConsumerStore.class.getName() + ".cache", (CacheLoader)new ConsumerCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void clearCaches(ClearCacheEvent event) {
        this.cache.removeAll();
    }

    public void put(Consumer consumer) throws StoreException {
        Assertions.notNull((String)"consumer", (Object)consumer);
        Assertions.notNull((String)"consumer.key", (Object)consumer.getKey());
        Assertions.notNull((String)"consumer.name", (Object)consumer.getName());
        Assertions.notNull((String)"consumer.publicKey", (Object)consumer.getPublicKey());
        try {
            this.delegateStore.put(consumer);
        }
        finally {
            this.cache.remove((Object)consumer.getKey());
        }
    }

    public Consumer get(String key) throws StoreException {
        Assertions.notNull((String)"key", (Object)key);
        return (Consumer)((CacheObject)this.cache.get((Object)key)).getValue();
    }

    public Iterable<Consumer> getAll() throws StoreException {
        return this.delegateStore.getAll();
    }

    public void remove(String key) throws StoreException {
        Assertions.notNull((String)"key", (Object)key);
        try {
            this.delegateStore.remove(key);
        }
        finally {
            this.cache.remove((Object)key);
        }
    }

    private class ConsumerCacheLoader
    implements CacheLoader<String, CacheObject<Consumer>> {
        private ConsumerCacheLoader() {
        }

        public CacheObject<Consumer> load(@Nonnull String key) {
            return CacheObject.wrap((Object)CachingServiceProviderConsumerStore.this.delegateStore.get(key));
        }
    }
}

