/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.consumer.core;

import com.atlassian.oauth.Consumer;
import com.google.common.base.Preconditions;
import java.security.PrivateKey;

public interface ConsumerServiceStore {
    public ConsumerAndSecret get(String var1);

    public ConsumerAndSecret getByKey(String var1);

    public void put(String var1, ConsumerAndSecret var2);

    public void removeByKey(String var1);

    public Iterable<Consumer> getAllServiceProviders();

    public static final class ConsumerAndSecret {
        private final String serviceName;
        private final Consumer consumer;
        private final String sharedSecret;
        private final PrivateKey privateKey;

        public ConsumerAndSecret(String serviceName, Consumer consumer, PrivateKey privateKey) {
            if (consumer.getSignatureMethod() == Consumer.SignatureMethod.HMAC_SHA1) {
                throw new IllegalArgumentException("consumer uses HMAC is being configured with an RSA private key");
            }
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
            this.consumer = (Consumer)Preconditions.checkNotNull((Object)consumer, (Object)"consumer");
            this.privateKey = (PrivateKey)Preconditions.checkNotNull((Object)privateKey, (Object)"privateKey");
            this.sharedSecret = null;
        }

        public ConsumerAndSecret(String serviceName, Consumer consumer, String sharedSecret) {
            if (consumer.getSignatureMethod() == Consumer.SignatureMethod.RSA_SHA1) {
                throw new IllegalArgumentException("consumer uses RSA is being configured with a shared secret");
            }
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
            this.consumer = (Consumer)Preconditions.checkNotNull((Object)consumer, (Object)"consumer");
            this.sharedSecret = (String)Preconditions.checkNotNull((Object)sharedSecret, (Object)"sharedSecret");
            this.privateKey = null;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public Consumer getConsumer() {
            return this.consumer;
        }

        public String getSharedSecret() {
            return this.sharedSecret;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }
    }
}

