/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.oauth.consumer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerCreationException;
import com.atlassian.oauth.consumer.core.ConsumerServiceStore;
import com.atlassian.oauth.consumer.core.HostConsumerAndSecretProvider;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.util.concurrent.LazyReference;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.UUID;

public class DefaultHostConsumerAndSecretProvider
implements HostConsumerAndSecretProvider {
    public static final String HOST_SERVICENAME = "__HOST_SERVICE__";
    private final ApplicationProperties applicationProperties;
    private final ConsumerServiceStore consumerStore;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final LazyReference<ConsumerServiceStore.ConsumerAndSecret> consumerAndSecretRef;

    public DefaultHostConsumerAndSecretProvider(ApplicationProperties applicationProperties, ConsumerServiceStore consumerStore) {
        this.applicationProperties = applicationProperties;
        this.consumerStore = consumerStore;
        this.jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        this.consumerAndSecretRef = new LazyReference<ConsumerServiceStore.ConsumerAndSecret>(){

            protected ConsumerServiceStore.ConsumerAndSecret create() throws Exception {
                return DefaultHostConsumerAndSecretProvider.this.createHostConsumerAndSecret();
            }
        };
    }

    @Override
    public ConsumerServiceStore.ConsumerAndSecret get() {
        ConsumerServiceStore.ConsumerAndSecret consumerAndSecret = this.consumerStore.get(HOST_SERVICENAME);
        if (consumerAndSecret == null) {
            ConsumerServiceStore.ConsumerAndSecret hostConsumerAndSecret = (ConsumerServiceStore.ConsumerAndSecret)this.consumerAndSecretRef.get();
            this.consumerStore.put(HOST_SERVICENAME, hostConsumerAndSecret);
            return this.consumerStore.get(HOST_SERVICENAME);
        }
        return consumerAndSecret;
    }

    @Override
    public ConsumerServiceStore.ConsumerAndSecret put(ConsumerServiceStore.ConsumerAndSecret consumerAndSecret) {
        this.consumerStore.put(consumerAndSecret.getServiceName(), consumerAndSecret);
        return this.consumerStore.get(consumerAndSecret.getServiceName());
    }

    private ConsumerServiceStore.ConsumerAndSecret createHostConsumerAndSecret() {
        KeyPair keyPair;
        try {
            keyPair = RSAKeys.generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw new ConsumerCreationException("Could not create key pair for consumer", (Throwable)e);
        }
        I18nHelper i18nBean = this.jiraAuthenticationContext.getI18nHelper();
        String description = i18nBean.getText("oauth.host.consumer.default.description", this.applicationProperties.getString("jira.baseurl"));
        Consumer consumer = Consumer.key((String)this.createConsumerKey()).name(this.applicationProperties.getDefaultBackedString("jira.title")).publicKey(keyPair.getPublic()).description(description).build();
        return new ConsumerServiceStore.ConsumerAndSecret(HOST_SERVICENAME, consumer, keyPair.getPrivate());
    }

    private String createConsumerKey() {
        return "jira:" + UUID.randomUUID();
    }
}

