/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.oauth.consumer;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.oauth.consumer.ConsumerToken;
import com.atlassian.oauth.consumer.ConsumerTokenStore;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class CachingConsumerTokenStore
implements ConsumerTokenStore,
InitializingBean,
DisposableBean {
    private final Cache<String, CacheObject<ConsumerToken>> cache;
    private ConsumerTokenStore delegateStore;
    private final EventPublisher eventPublisher;

    public CachingConsumerTokenStore(ConsumerTokenStore delegateStore, EventPublisher eventPublisher, CacheManager cacheManager) {
        this.eventPublisher = eventPublisher;
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.delegateStore = delegateStore;
        this.cache = cacheManager.getCache(CachingConsumerTokenStore.class.getName() + ".cache", (CacheLoader)new ConsumerTokenCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(4000).build());
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void clearCaches(ClearCacheEvent event) {
        this.cache.removeAll();
    }

    public ConsumerToken get(ConsumerTokenStore.Key key) {
        Assertions.notNull((String)"key", (Object)key);
        return (ConsumerToken)((CacheObject)this.cache.get((Object)key.getKey())).getValue();
    }

    public Map<ConsumerTokenStore.Key, ConsumerToken> getConsumerTokens(String consumerKey) {
        return this.delegateStore.getConsumerTokens(consumerKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerToken put(ConsumerTokenStore.Key key, ConsumerToken token) {
        Assertions.notNull((String)"key", (Object)key);
        Assertions.notNull((String)"token", (Object)token);
        try {
            ConsumerToken consumerToken = this.delegateStore.put(key, token);
            return consumerToken;
        }
        finally {
            this.cache.remove((Object)key.getKey());
        }
    }

    public void remove(ConsumerTokenStore.Key key) {
        Assertions.notNull((String)"key", (Object)key);
        try {
            this.delegateStore.remove(key);
        }
        finally {
            this.cache.remove((Object)key.getKey());
        }
    }

    public void removeTokensForConsumer(String consumerKey) {
        Assertions.notNull((String)"consumerKey", (Object)consumerKey);
        this.delegateStore.removeTokensForConsumer(consumerKey);
        this.cache.removeAll();
    }

    private class ConsumerTokenCacheLoader
    implements CacheLoader<String, CacheObject<ConsumerToken>> {
        private ConsumerTokenCacheLoader() {
        }

        public CacheObject<ConsumerToken> load(@Nonnull String key) {
            return CacheObject.wrap((Object)CachingConsumerTokenStore.this.delegateStore.get(new ConsumerTokenStore.Key(key)));
        }
    }
}

