/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.my_home;

import com.atlassian.jira.my_home.MyJiraHomeStorage;
import com.atlassian.jira.my_home.MyJiraHomeUpdateService;
import com.atlassian.jira.my_home.MyJiraHomeValidator;
import com.atlassian.jira.plugin.myjirahome.MyJiraHomeUpdateException;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;

public class MyJiraHomeUpdateServiceImpl
implements MyJiraHomeUpdateService {
    private final MyJiraHomeValidator validator;
    private final MyJiraHomeStorage storage;

    public MyJiraHomeUpdateServiceImpl(@Nonnull MyJiraHomeValidator validator, @Nonnull MyJiraHomeStorage storage) {
        this.validator = validator;
        this.storage = storage;
    }

    @Override
    public void updateHome(@Nonnull ApplicationUser user, @Nonnull String completePluginModuleKey) {
        if (!Strings.isNullOrEmpty((String)completePluginModuleKey.trim()) && this.validator.isInvalid(completePluginModuleKey)) {
            throw new MyJiraHomeUpdateException("The plugin module key is not usable. Please double check the URL query string and make sure it contains a valid Atlassian plugin module key.");
        }
        this.storage.store(user, completePluginModuleKey);
    }
}

