/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.monitor.rrd4j;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.plugins.monitor.MonitorService;
import com.atlassian.jira.plugins.monitor.rrd4j.BackendFactory;
import com.atlassian.jira.plugins.monitor.rrd4j.Graph;
import com.atlassian.jira.plugins.monitor.rrd4j.GraphRegistry;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RrdUpdater
implements MonitorService {
    private static final Logger log = LoggerFactory.getLogger(RrdUpdater.class);
    private final JiraHome jiraHome;
    private final GraphRegistry graphRegistry;
    private BackendFactory backendFactory;
    private Map<Graph, RrdDb> rrdDbs = Maps.newHashMap();

    public RrdUpdater(GraphRegistry graphRegistry, JiraHome jiraHome) {
        this.graphRegistry = graphRegistry;
        this.jiraHome = jiraHome;
    }

    @Override
    public void start() throws Exception {
        this.backendFactory = new BackendFactory();
        this.createOrOpenDatabaseFiles();
    }

    @Override
    public void stop() throws Exception {
        this.closeDatabaseFiles();
        this.backendFactory.shutdown();
    }

    public File getRrdDbPathFor(Graph graph) {
        File rrDbDir = new File(this.jiraHome.getLocalHome() + File.separator + "monitor");
        if (!rrDbDir.exists() && !rrDbDir.mkdirs()) {
            log.error("Error creating database dir: {}", (Object)rrDbDir.getAbsolutePath());
        }
        return new File(rrDbDir, graph.getClass().getSimpleName() + ".rrd4j");
    }

    public void addSample() throws IOException {
        for (Graph graph : this.graphRegistry.getGraphs()) {
            RrdDb rrdDb = this.rrdDbs.get(graph);
            if (rrdDb == null) continue;
            Sample sample = rrdDb.createSample();
            sample.setTime(System.currentTimeMillis() / 1000L);
            graph.setDatasourceValues(sample);
            try {
                sample.update();
            }
            catch (IllegalArgumentException t) {
                log.debug("Error adding sample", (Throwable)t);
            }
        }
    }

    private void createOrOpenDatabaseFiles() throws IOException {
        for (Graph graph : this.graphRegistry.getGraphs()) {
            File graphDbFile = this.getRrdDbPathFor(graph);
            if (graphDbFile.exists()) {
                log.info("Reusing existing RrdDb: {}", (Object)graphDbFile);
                this.rrdDbs.put(graph, new RrdDb(graphDbFile.getAbsolutePath(), this.backendFactory.getBackendFactory()));
                continue;
            }
            RrdDef rrdDef = this.createRrdDef(graphDbFile);
            graph.addDatasources(rrdDef);
            log.info("Creating new RrdDb: {}", (Object)graphDbFile);
            this.rrdDbs.put(graph, new RrdDb(rrdDef, this.backendFactory.getBackendFactory()));
        }
    }

    private void closeDatabaseFiles() throws IOException {
        for (RrdDb rrdDb : this.rrdDbs.values()) {
            try {
                rrdDb.close();
            }
            catch (IOException e) {
                log.error("Error closing RrdDb: " + rrdDb, (Throwable)e);
            }
        }
    }

    private RrdDef createRrdDef(File rrdbFile) {
        int step = 10;
        RrdDef rrdDef = new RrdDef(rrdbFile.getAbsolutePath(), (long)step);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 1, this.toSeconds(TimeUnit.HOURS, 24 / step));
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 120, 168);
        return rrdDef;
    }

    private int toSeconds(TimeUnit unit, int duration) {
        return (int)TimeUnit.SECONDS.convert(duration, unit);
    }
}

