/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.monitor.database;

import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.plugins.monitor.MonitorAction;
import com.atlassian.jira.plugins.monitor.MonitoringFeature;
import com.atlassian.jira.plugins.monitor.rrd4j.Graph;
import com.atlassian.jira.plugins.monitor.rrd4j.GraphRegistry;
import com.atlassian.jira.plugins.monitor.rrd4j.RrdUpdater;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.sal.api.message.HelpPath;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.joda.time.DateTime;
import org.joda.time.Hours;
import org.joda.time.ReadablePeriod;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.util.TextUtil;

@WebSudoRequired
public class MonitorDatabase
extends MonitorAction {
    private static final Logger log = LoggerFactory.getLogger(MonitorDatabase.class);
    private final RrdUpdater databaseRrdUpdater;
    private final JiraBaseUrls jiraBaseUrls;
    private final GraphRegistry graphRegistry;
    private final HelpPathResolver helpPathResolver;
    private ImmutableList<GraphBean> graphs;
    private int hours = 6;
    private final ChartUtils chartUtils;

    public MonitorDatabase(RrdUpdater databaseRrdUpdater, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, JiraBaseUrls jiraBaseUrls, GraphRegistry graphRegistry, MonitoringFeature monitoringFeature, HelpPathResolver helpPathResolver, ChartUtils chartUtils) {
        super(permissionManager, jiraAuthenticationContext, monitoringFeature);
        this.databaseRrdUpdater = databaseRrdUpdater;
        this.jiraBaseUrls = jiraBaseUrls;
        this.graphRegistry = graphRegistry;
        this.helpPathResolver = helpPathResolver;
        this.chartUtils = chartUtils;
    }

    public ImmutableList<GraphBean> getGraphs() {
        if (this.graphs == null) {
            this.graphs = this.createGraphs();
        }
        return this.graphs;
    }

    public String getDatabaseConnectionHelpLinkHtml() {
        HelpPath helpPath = this.helpPathResolver.getHelpPath("dbconfig.generic");
        return "<a href=\"" + helpPath.getUrl() + "\" target=\"_blank\">" + TextUtil.escapeHTML((String)helpPath.getTitle()) + "</a>";
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    private ImmutableList<GraphBean> createGraphs() {
        ArrayList graphBeans = Lists.newArrayList();
        for (Graph graph : this.graphRegistry.getGraphs()) {
            try {
                String chartContent = this.createImageFile(graph);
                log.debug("Created image for: {}", (Object)graph);
                graphBeans.add(new GraphBean(this.getText(graph.getTitleI18nKey()), chartContent));
            }
            catch (IOException e) {
                log.error("Error creating graph for: " + graph, (Throwable)e);
            }
        }
        return ImmutableList.copyOf((Collection)graphBeans);
    }

    private RrdGraphDef createGraphDefinition() {
        RrdGraphDef gDef = new RrdGraphDef();
        gDef.setImageFormat("png");
        gDef.setWidth(800);
        gDef.setHeight(300);
        gDef.setValueAxis(1.0, 1);
        gDef.setMinValue(0.0);
        return gDef;
    }

    private String createImageFile(Graph graph) throws IOException {
        RrdGraphDef gDef = this.createGraphDefinition();
        graph.addGraphElements(gDef, this.databaseRrdUpdater.getRrdDbPathFor(graph).getAbsolutePath());
        DateTime now = new DateTime();
        gDef.setTitle(this.getText(graph.getTitleI18nKey()));
        gDef.setTimeSpan(now.minus((ReadablePeriod)Hours.hours((int)this.hours)).getMillis() / 1000L, now.getMillis() / 1000L);
        gDef.setLargeFont(new Font("sansserif", 0, 14));
        gDef.setSmallFont(new Font("sansserif", 0, 12));
        gDef.comment("\\l");
        gDef.comment(this.jiraBaseUrls.baseUrl() + "\\L");
        gDef.comment(now + "\\r");
        RrdGraph rrdGraph = new RrdGraph(gDef);
        ByteArrayInputStream chartInputStream = new ByteArrayInputStream(rrdGraph.getRrdGraphInfo().getBytes());
        return this.chartUtils.renderBase64Chart(ImageIO.read(chartInputStream), "Database Monitoring Chart, " + graph);
    }

    public static class GraphBean {
        private final String title;
        private final String base64Image;

        private GraphBean(String title, String base64Image) {
            this.title = title;
            this.base64Image = base64Image;
        }

        public String getTitle() {
            return this.title;
        }

        public String getBase64Image() {
            return this.base64Image;
        }

        public String toString() {
            return "Title: " + this.title;
        }
    }
}

