/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.monitor.database;

import com.atlassian.instrumentation.Instrument;
import com.atlassian.instrumentation.operations.OpCounter;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.plugins.monitor.rrd4j.Graph;
import java.awt.Color;
import java.awt.Paint;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.rrd4j.graph.RrdGraphDef;

public class DatabaseReadWritesGraph
implements Graph {
    @Override
    public String getTitleI18nKey() {
        return "admin.monitor.database.read.writes";
    }

    @Override
    public void addDatasources(RrdDef rrdDef) {
        rrdDef.addDatasource("db.reads.inv", DsType.DERIVE, 20L, 0.0, Double.NaN);
        rrdDef.addDatasource("db.reads.time", DsType.DERIVE, 20L, 0.0, Double.NaN);
        rrdDef.addDatasource("db.writes.inv", DsType.DERIVE, 20L, 0.0, Double.NaN);
        rrdDef.addDatasource("db.writes.time", DsType.DERIVE, 20L, 0.0, Double.NaN);
    }

    @Override
    public void setDatasourceValues(Sample sample) {
        Instrument dbWrites;
        Instrument dbReads = Instrumentation.getInstrument((String)InstrumentationName.DB_READS.getInstrumentName());
        if (dbReads instanceof OpCounter) {
            OpCounter counter = (OpCounter)dbReads;
            sample.setValue("db.reads.inv", (double)counter.getInvocationCount());
            sample.setValue("db.reads.time", (double)counter.getCpuTime());
        }
        if ((dbWrites = Instrumentation.getInstrument((String)InstrumentationName.DB_WRITES.getInstrumentName())) instanceof OpCounter) {
            OpCounter writesCounter = (OpCounter)dbWrites;
            sample.setValue("db.writes.inv", (double)writesCounter.getInvocationCount());
            sample.setValue("db.writes.time", (double)writesCounter.getCpuTime());
        }
    }

    @Override
    public void addGraphElements(RrdGraphDef rrdGraphDef, String rrdPath) {
        rrdGraphDef.setValueAxis(10.0, 1);
        rrdGraphDef.datasource("db.reads.rate", rrdPath, "db.reads.inv", ConsolFun.AVERAGE);
        rrdGraphDef.datasource("db.reads.rate.per.second", String.format("db.reads.rate,%d,/", 10));
        rrdGraphDef.datasource("db.writes.rate", rrdPath, "db.writes.inv", ConsolFun.AVERAGE);
        rrdGraphDef.datasource("db.writes.rate.per.second", String.format("db.writes.rate,%d,/", 10));
        rrdGraphDef.line("db.writes.rate.per.second", (Paint)Color.BLUE, "Writes / sec\\L");
        rrdGraphDef.gprint("db.writes.rate.per.second", ConsolFun.AVERAGE, " avg:%2.2f");
        rrdGraphDef.gprint("db.writes.rate.per.second", ConsolFun.MAX, "max: %2.2f\\r");
        rrdGraphDef.line("db.reads.rate.per.second", (Paint)Color.RED, "Reads / sec\\L");
        rrdGraphDef.gprint("db.reads.rate.per.second", ConsolFun.AVERAGE, " avg:%2.2f");
        rrdGraphDef.gprint("db.reads.rate.per.second", ConsolFun.MAX, "max: %2.2f\\r");
    }
}

