/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.monitor.database;

import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.plugins.monitor.rrd4j.Graph;
import java.awt.Color;
import java.awt.Paint;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.rrd4j.graph.RrdGraphDef;

public class ConnectionPoolGraph
implements Graph {
    @Override
    public String getTitleI18nKey() {
        return "admin.monitor.connection.pool";
    }

    @Override
    public void addDatasources(RrdDef rrdDef) {
        rrdDef.addDatasource(InstrumentationName.DBCP_ACTIVE.getInstrumentName(), DsType.GAUGE, 20L, 0.0, Double.NaN);
        rrdDef.addDatasource(InstrumentationName.DBCP_IDLE.getInstrumentName(), DsType.GAUGE, 20L, 0.0, Double.NaN);
    }

    @Override
    public void setDatasourceValues(Sample sample) {
        Instrument idle;
        Instrument active = Instrumentation.getInstrument((String)InstrumentationName.DBCP_ACTIVE.getInstrumentName());
        if (active != null) {
            sample.setValue(InstrumentationName.DBCP_ACTIVE.getInstrumentName(), (double)active.getValue());
        }
        if ((idle = Instrumentation.getInstrument((String)InstrumentationName.DBCP_IDLE.getInstrumentName())) != null) {
            sample.setValue(InstrumentationName.DBCP_IDLE.getInstrumentName(), (double)idle.getValue());
        }
    }

    @Override
    public void addGraphElements(RrdGraphDef rrdGraphDef, String rrdPath) {
        Instrument maxActive = Instrumentation.getInstrument((String)InstrumentationName.DBCP_MAX.getInstrumentName());
        if (maxActive != null) {
            rrdGraphDef.setMaxValue((double)maxActive.getValue());
        }
        rrdGraphDef.datasource("active.conns", rrdPath, InstrumentationName.DBCP_ACTIVE.getInstrumentName(), ConsolFun.AVERAGE);
        rrdGraphDef.datasource("idle.conns", rrdPath, InstrumentationName.DBCP_IDLE.getInstrumentName(), ConsolFun.AVERAGE);
        rrdGraphDef.area("active.conns", (Paint)Color.BLUE, "NumActive\\L");
        rrdGraphDef.gprint("active.conns", ConsolFun.MIN, "min: %.0f");
        rrdGraphDef.gprint("active.conns", ConsolFun.MAX, "max: %.0f\\r");
        rrdGraphDef.stack("idle.conns", (Paint)Color.GREEN, "NumIdle\\L");
        rrdGraphDef.gprint("idle.conns", ConsolFun.MIN, "min: %.0f");
        rrdGraphDef.gprint("idle.conns", ConsolFun.MAX, "max: %.0f\\r");
    }
}

