/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.monitor;

import com.atlassian.jira.plugins.monitor.MetricsCollectorTask;
import com.atlassian.jira.plugins.monitor.MonitorService;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringScheduler
implements MonitorService {
    private static final Logger log = LoggerFactory.getLogger(MonitoringScheduler.class);
    private final MetricsCollectorTask metricsCollectorTask;
    private volatile Timer timer;

    public MonitoringScheduler(MetricsCollectorTask metricsCollectorTask) {
        this.metricsCollectorTask = metricsCollectorTask;
    }

    @Override
    public void start() throws Exception {
        this.timer = new Timer("jira-monitoring-plugin", true);
        long pollingInterval = 10000L;
        log.info("Scheduling metrics collector to run every {}ms...", (Object)pollingInterval);
        this.timer.schedule((TimerTask)this.metricsCollectorTask.cloneTask(), pollingInterval, pollingInterval);
    }

    @Override
    public void stop() throws Exception {
        log.info("Unscheduling metrics collector...");
        this.timer.cancel();
    }
}

