/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.monitor;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.monitor.MonitorService;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MonitorLauncher
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MonitorLauncher.class);
    private static final String PLUGIN_KEY = "com.atlassian.jira.jira-monitoring-plugin";
    private final EventPublisher eventPublisher;
    private final List<MonitorService> monitorServices;
    private volatile State state = new NotMonitoring();

    public MonitorLauncher(EventPublisher eventPublisher, List<MonitorService> monitorServices) {
        this.eventPublisher = eventPublisher;
        this.monitorServices = monitorServices;
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.shutdown();
    }

    @EventListener
    public void pluginEnabled(PluginEnabledEvent event) {
        if (PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            this.state.onPluginEnabled();
        }
    }

    @EventListener
    public void pluginDisabled(PluginDisabledEvent event) {
        if (PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            this.shutdown();
        }
    }

    private void shutdown() {
        this.eventPublisher.unregister((Object)this);
        this.state.onPluginDisabled();
    }

    private void startMonitoring() {
        for (MonitorService monitorService : this.monitorServices) {
            log.debug("Starting {}", (Object)monitorService);
            try {
                monitorService.start();
            }
            catch (Exception e) {
                log.error("Failed to start: " + monitorService, (Throwable)e);
            }
        }
        log.info("Started JIRA monitoring");
    }

    private void stopMonitoring() {
        ListIterator<MonitorService> it = this.monitorServices.listIterator(this.monitorServices.size());
        while (it.hasPrevious()) {
            MonitorService monitorService = it.previous();
            log.debug("Stopping {}", (Object)monitorService);
            try {
                monitorService.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop " + monitorService, (Throwable)e);
            }
        }
        log.info("Stopped JIRA monitoring");
    }

    protected void changeStateTo(State enterState) {
        State leaveState = this.state;
        log.debug("Changing state from '{}' to '{}'", (Object)leaveState.getClass().getSimpleName(), (Object)enterState.getClass().getSimpleName());
        leaveState.leave();
        enterState.enter();
        this.state = enterState;
    }

    private class Monitoring
    extends State {
        private Monitoring() {
        }

        @Override
        public void enter() {
            MonitorLauncher.this.startMonitoring();
        }

        @Override
        void leave() {
            MonitorLauncher.this.stopMonitoring();
        }

        @Override
        void onPluginDisabled() {
            MonitorLauncher.this.changeStateTo(new NotMonitoring());
        }
    }

    private class NotMonitoring
    extends State {
        private NotMonitoring() {
        }

        @Override
        void onPluginEnabled() {
            MonitorLauncher.this.changeStateTo(new Monitoring());
        }
    }

    private static abstract class State {
        private State() {
        }

        void enter() {
        }

        void leave() {
        }

        void onPluginEnabled() {
        }

        void onPluginDisabled() {
        }
    }
}

