/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.gzipfilter.org.apache.commons.lang.exception.ExceptionUtils;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.plugins.mail.webwork.AddSmtpMailServer;
import com.atlassian.jira.plugins.mail.webwork.MailServerActionSupport;
import com.atlassian.jira.plugins.mail.webwork.VerifyMailServer;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.MailConstants;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Map;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import org.apache.commons.lang.StringUtils;

public class VerifySmtpServerConnection
extends MailServerActionSupport {
    private String provider;
    private final MailLoggingManager mailLoggingManager;
    protected static long verifyTimeout;

    public VerifySmtpServerConnection(MailLoggingManager mailLoggingManager, WebResourceManager webResourceManager) {
        this.mailLoggingManager = mailLoggingManager;
        webResourceManager.requireResource("com.atlassian.jira.jira-mail-plugin:verifymailserverconnection");
        webResourceManager.requireResource("com.atlassian.jira.jira-mail-plugin:mail-servers");
    }

    @Override
    public String doDefault() throws Exception {
        return "input";
    }

    protected void validateServer(MailServer mailServer, VerifyMailServer verifier) {
        verifier.verifyMailServer(mailServer);
        if (verifier.hasErrors()) {
            this.setErrorMessages(verifier.getErrorMessages());
        }
    }

    protected String doExecute() throws Exception {
        if (!this.canManageSmtpMailServers() && this.isJiraSetup()) {
            this.setErrorMessages((Collection)ImmutableList.of((Object)this.getI18nHelper().getText("perm.violation.desc")));
            return "securitybreach";
        }
        String port = this.getPort();
        String protocol = this.getProtocol();
        verifyTimeout = this.getTimeout() == null || this.getTimeout() <= 0L ? 10000L : this.getTimeout();
        MailProtocol mailProtocol = StringUtils.isNotBlank((String)protocol) ? MailProtocol.getMailProtocol((String)protocol.trim()) : MailConstants.DEFAULT_SMTP_PROTOCOL;
        port = StringUtils.isNotBlank((String)port) ? port.trim() : mailProtocol.getDefaultPort();
        SMTPMailServerImpl mailServer = TextUtils.stringSet((String)this.getJndiLocation()) ? new SMTPMailServerImpl(null, this.getName(), this.getDescription(), this.getFrom(), this.getPrefix(), true, mailProtocol, this.getJndiLocation(), port, this.isTlsRequired(), this.getUsername(), this.getPassword(), verifyTimeout) : new SMTPMailServerImpl(null, this.getName(), this.getDescription(), this.getFrom(), this.getPrefix(), false, mailProtocol, this.getServerName(), port, this.isTlsRequired(), this.getUsername(), this.getPassword(), verifyTimeout);
        this.configureSocks((MailServer)mailServer);
        this.mailLoggingManager.configureLogging((MailServer)mailServer);
        this.validateServer((MailServer)mailServer, new VerifySmptServer());
        return "success";
    }

    private boolean isJiraSetup() {
        return this.getApplicationProperties().getString("jira.setup") != null;
    }

    public String doAdd() throws Exception {
        this.setChangePassword(true);
        this.doVerification();
        return "add";
    }

    private void doVerification() throws Exception {
        this.doValidation();
        if (!this.hasAnyErrors()) {
            this.doExecute();
        }
    }

    public String doUpdate() throws Exception {
        this.doVerification();
        return "update";
    }

    public String doSetup() throws Exception {
        this.setChangePassword(true);
        this.doVerification();
        return "setup";
    }

    public boolean isAnonymous() {
        return StringUtils.isBlank((String)this.getUsername()) && StringUtils.isBlank((String)this.getJndiLocation());
    }

    public String getServiceProvider() {
        return this.provider;
    }

    public void setServiceProvider(String provider) {
        this.provider = provider;
    }

    public Map<String, String> getSupportedServiceProviders() {
        return AddSmtpMailServer.getSupportedServiceProviders((I18nHelper)this);
    }

    @Override
    public String getActiveTab() {
        return "outgoing_mail";
    }

    public String getCancelURI() {
        return "OutgoingMailServers.jspa";
    }

    static class VerifySmptServer
    extends VerifyMailServer {
        VerifySmptServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void verifyMailServer(MailServer server) {
            Transport transport = null;
            try {
                this.addTimeouts(server, verifyTimeout);
                Session session = server.getSession();
                if (session != null) {
                    SMTPMailServer smtpServer = (SMTPMailServer)server;
                    transport = session.getTransport();
                    if (smtpServer.isSessionServer()) {
                        transport.connect();
                        if (!transport.isConnected()) {
                            this.errors.add(this.getI18nHelper().getText("admin.mailservers.mail.bad.jndisession"));
                            log.error((Object)String.format("Unable to connect to %s specified in JNDI", smtpServer.getJndiLocation()));
                        }
                    } else {
                        transport.connect(server.getHostname(), Integer.parseInt(server.getPort()), server.getUsername(), server.getPassword());
                        if (!transport.isConnected()) {
                            this.errors.add(this.getI18nHelper().getText("admin.mailservers.mail.bad.authentication"));
                            log.error((Object)String.format("Unable to authenticate to %s", smtpServer.getHostname()));
                        }
                    }
                } else {
                    this.errors.add(this.getI18nHelper().getText("admin.mailservers.mail.bad.session"));
                    log.error((Object)"Unable to retrieve a seesion from the SMTP mail server");
                }
            }
            catch (Exception e) {
                Throwable t = ExceptionUtils.getRootCause((Throwable)e) != null ? ExceptionUtils.getRootCause((Throwable)e) : e;
                String message = t.getMessage();
                if (t instanceof AuthenticationFailedException && (StringUtils.containsIgnoreCase((String)message, (String)"mechansims") || StringUtils.containsIgnoreCase((String)message, (String)"mechanisms"))) {
                    this.errors.add(this.getI18nHelper().getText("jmp.no.authentication.mechanisms.proposed"));
                } else {
                    this.errors.add(String.format("%s: %s", t.getClass().getSimpleName(), message));
                }
                log.error((Object)String.format("Unable to connect to the server at %s due to the following exception: %s", server.getHostname(), t.toString()));
            }
            finally {
                if (transport != null) {
                    try {
                        transport.close();
                    }
                    catch (MessagingException ignore) {
                        log.error((Object)("Exception when closing transport " + ignore.getMessage()));
                    }
                }
            }
        }
    }
}

