/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.gzipfilter.org.apache.commons.lang.exception.ExceptionUtils;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.plugins.mail.webwork.AddPopMailServer;
import com.atlassian.jira.plugins.mail.webwork.VerifyMailServer;
import com.atlassian.mail.MailConstants;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.impl.PopMailServerImpl;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.commons.lang.StringUtils;

public class VerifyPopServerConnection
extends AddPopMailServer {
    private final MailLoggingManager mailLoggingManager;
    protected static long verifyTimeout;

    public VerifyPopServerConnection(MailLoggingManager mailLoggingManager) {
        this.mailLoggingManager = mailLoggingManager;
    }

    @Override
    public String doDefault() throws Exception {
        return "input";
    }

    protected void validateServer(MailServer mailServer, VerifyMailServer verifier) {
        verifier.verifyMailServer(mailServer);
        if (verifier.hasErrors()) {
            this.setErrorMessages(verifier.getErrorMessages());
        }
    }

    @Override
    protected String doExecute() throws Exception {
        String port = this.getPort();
        String protocol = this.getProtocol();
        verifyTimeout = this.getTimeout() == null || this.getTimeout() <= 0L ? 10000L : this.getTimeout();
        MailProtocol mailProtocol = StringUtils.isNotBlank((String)protocol) ? MailProtocol.getMailProtocol((String)protocol.trim()) : MailConstants.DEFAULT_POP_PROTOCOL;
        port = StringUtils.isNotBlank((String)port) ? port.trim() : mailProtocol.getDefaultPort();
        PopMailServerImpl mailServer = new PopMailServerImpl(null, this.getName(), this.getDescription(), mailProtocol, this.getServerName(), port, this.getUsername(), this.getPassword(), verifyTimeout);
        this.configureSocks((MailServer)mailServer);
        this.mailLoggingManager.configureLogging((MailServer)mailServer);
        this.validateServer((MailServer)mailServer, new VerifyPopServer());
        return "success";
    }

    public String doAdd() throws Exception {
        this.doValidation();
        if (!this.hasAnyErrors()) {
            this.doExecute();
        }
        return "add";
    }

    public String doUpdate() throws Exception {
        this.doValidation();
        if (!this.hasAnyErrors()) {
            this.doExecute();
        }
        return "update";
    }

    static class VerifyPopServer
    extends VerifyMailServer {
        VerifyPopServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void verifyMailServer(MailServer server) {
            Store store = null;
            try {
                this.addTimeouts(server, verifyTimeout);
                Session session = server.getSession();
                store = session.getStore(server.getMailProtocol().getProtocol());
                store.connect(server.getHostname(), Integer.parseInt(server.getPort()), server.getUsername(), server.getPassword());
            }
            catch (Exception e) {
                Throwable rootCause = e.getCause() != null ? ExceptionUtils.getRootCause((Throwable)e) : e;
                String faultMessage = String.format("%s: %s", rootCause.getClass().getSimpleName(), rootCause.getMessage());
                log.error((Object)String.format("Unable to connect to the server at %s due to the following exception: %s", server.getHostname(), rootCause.toString()));
                this.errors.add(faultMessage);
            }
            finally {
                if (store != null) {
                    try {
                        store.close();
                    }
                    catch (MessagingException messagingException) {}
                }
            }
        }
    }
}

