/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.jira.plugins.mail.ImapServersValuesGenerator;
import com.atlassian.jira.plugins.mail.PopServersValuesGenerator;
import com.atlassian.jira.plugins.mail.ServiceConfiguration;
import com.atlassian.jira.plugins.mail.extensions.MessageHandlerModuleDescriptor;
import com.atlassian.jira.plugins.mail.extensions.MessageHandlerValidator;
import com.atlassian.jira.plugins.mail.extensions.PluggableMailHandlerUtils;
import com.atlassian.jira.plugins.mail.webwork.MailWebActionSupport;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.services.mail.MailFetcherService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;

@WebSudoRequired
public class EditServerDetailsWebAction
extends MailWebActionSupport {
    private String handler;
    private String mailServer;
    private String serviceName;
    private String folder;
    private Long delay = 1L;
    private Long serviceId;
    private MessageHandlerModuleDescriptor descriptor;
    private final ProjectManager projectManager;
    private final PluginAccessor pluginAccessor;

    public EditServerDetailsWebAction(ProjectManager projectManager, PluginAccessor pluginAccessor) {
        this.projectManager = projectManager;
        this.pluginAccessor = pluginAccessor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String doDefault() throws Exception {
        String result = super.doDefault();
        ActionContext.getSession().put(ServiceConfiguration.ID, null);
        if (this.serviceId == null) return result;
        if (!this.canEditService(this.serviceId)) return "securitybreach";
        JiraServiceContainer service = this.getService(this.serviceId);
        if (service == null) return this.returnCompleteWithInlineRedirect("IncomingMailServers.jspa");
        this.serviceName = service.getName();
        this.delay = service.getDelay() / 60000L;
        this.mailServer = service.getProperty("popserver");
        this.folder = MailFetcherService.class.getName().equals(service.getServiceClass()) ? service.getProperty("foldername") : service.getProperty("subdirectory");
        this.handler = this.getHandlerKey(service.getProperty("handler"));
        return result;
    }

    @Nullable
    private String getHandlerKey(@Nonnull String messageHandler) {
        MessageHandlerModuleDescriptor descriptor = PluggableMailHandlerUtils.getHandlerKeyByMessageHandler(this.pluginAccessor, messageHandler);
        return descriptor != null ? descriptor.getCompleteKey() : null;
    }

    protected void doValidation() {
        ErrorCollection errorCollection;
        MessageHandlerValidator validator;
        super.doValidation();
        if (StringUtils.isBlank((String)this.serviceName)) {
            this.addError("serviceName", this.getText("admin.errors.specify.service.name"));
        }
        if (this.delay == null) {
            this.addError("delay", this.getText("EMPTY_LONG"));
        } else if (this.delay < 1L) {
            this.addError("delay", this.getText("admin.errors.delay.too.short"));
        }
        if (StringUtils.isNotBlank((String)this.mailServer) || !this.isSystemAdministrator()) {
            try {
                Long.parseLong(this.mailServer);
            }
            catch (Exception e) {
                this.addError("mailServer", this.getText("jmp.editServerDetails.please.select.server"));
            }
        }
        try {
            this.descriptor = (MessageHandlerModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(this.handler);
        }
        catch (Exception e) {
            this.addError("handler", e.getMessage());
        }
        if (this.descriptor != null && (validator = this.descriptor.getValidator()) != null && (errorCollection = validator.validate()).hasAnyErrors()) {
            this.addError("handler", StringUtils.join((Collection)errorCollection.getErrorMessages(), (String)"\n"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ServiceConfiguration configuration = new ServiceConfiguration();
        configuration.setHandlerKey(this.getHandler());
        if (StringUtils.isNotBlank((String)this.mailServer)) {
            configuration.setServerId(Long.parseLong(this.mailServer));
        }
        configuration.setDelay(this.delay);
        configuration.setServiceName(this.serviceName);
        configuration.setServiceId(this.serviceId);
        if (!StringUtils.isBlank((String)this.folder)) {
            configuration.setFolder(this.folder);
        }
        if (this.isEditing() && !this.canEditService(this.serviceId) || !this.isEditing() && !this.canAddService(configuration.getServiceClass())) {
            return "securitybreach";
        }
        ActionContext.getSession().put(ServiceConfiguration.ID, configuration);
        String url = this.descriptor.getAddEditUrl();
        if (this.isInlineDialogMode()) {
            url = url + (url.contains("?") ? "&" : "?") + "decorator=dialog&inline=true";
        }
        return this.getRedirect(url);
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getMailServer() {
        return this.mailServer;
    }

    public void setMailServer(String mailServer) {
        this.mailServer = mailServer;
    }

    @Nonnull
    public Map<String, String> getImapServers() {
        return new ImapServersValuesGenerator().getValues(Collections.emptyMap());
    }

    @Nonnull
    public Map<String, String> getPopServers() {
        return new PopServersValuesGenerator().getValues(Collections.emptyMap());
    }

    @Nonnull
    public Map<String, String> getHandlers() {
        LinkedHashMap handlers = Maps.newLinkedHashMap();
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(MessageHandlerModuleDescriptor.class);
        Comparator<MessageHandlerModuleDescriptor> compareWeights = new Comparator<MessageHandlerModuleDescriptor>(){

            @Override
            public int compare(MessageHandlerModuleDescriptor o1, MessageHandlerModuleDescriptor o2) {
                return ComparisonChain.start().compare(o1.getWeight(), o2.getWeight()).compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName())).result();
            }
        };
        for (MessageHandlerModuleDescriptor descriptor : ImmutableSortedSet.copyOf((Comparator)compareWeights, (Collection)descriptors)) {
            handlers.put(descriptor.getCompleteKey(), descriptor.getName());
        }
        return handlers;
    }

    @Nonnull
    public Map<String, Map<String, String>> getMailServers() {
        Map<String, String> imapServers = this.getImapServers();
        Map<String, String> popServers = this.getPopServers();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!imapServers.isEmpty()) {
            builder.put((Object)"IMAP", imapServers);
        }
        if (!popServers.isEmpty()) {
            builder.put((Object)"POP3", popServers);
        }
        return builder.build();
    }

    public Long getDelay() {
        return this.delay;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    @Nullable
    public Long getServiceId() {
        return this.serviceId;
    }

    public boolean isEditing() {
        return this.serviceId != null;
    }
}

