/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.jira.plugins.mail.webwork.MailServerActionSupport;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class DeleteMailServer
extends MailServerActionSupport {
    private boolean confirmed;
    private final MailServerManager mailServerManager;

    public DeleteMailServer(MailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
    }

    @Override
    protected void doValidation() {
        if (this.getId() == null || !this.isConfirmed()) {
            this.addErrorMessage(this.getText("admin.errors.mail.confirm.deletion.of.server"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.canDeleteMailServer()) {
            boolean wasSmtp = this.isSmtp(this.mailServerManager.getMailServer(this.getId()));
            this.mailServerManager.delete(this.getId());
            return this.getRedirect(wasSmtp ? "OutgoingMailServers.jspa" : "IncomingMailServers.jspa");
        }
        return "securitybreach";
    }

    private boolean canDeleteMailServer() throws MailException {
        MailServer mailServer = this.mailServerManager.getMailServer(this.getId());
        if (mailServer == null) {
            return false;
        }
        if (this.isPop(mailServer)) {
            return this.canManagePopMailServers();
        }
        if (this.isSmtp(mailServer)) {
            return this.canManageSmtpMailServers();
        }
        return false;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    @Override
    public String getActiveTab() {
        return MailServerManager.SERVER_TYPES[1].equals(this.getType()) ? "outgoing_mail" : "incoming_mail";
    }

    public String getCancelURI() {
        return MailServerManager.SERVER_TYPES[1].equals(this.getType()) ? "OutgoingMailServers.jspa" : "IncomingMailServers.jspa";
    }
}

