/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.plugins.mail.webwork.AddMailServer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public class AddSmtpMailServer
extends AddMailServer {
    private final NotificationSchemeManager notificationSchemeManager;
    private Collection<Project> projects;

    public static Map<String, String> getSupportedServiceProviders(I18nHelper i18nHelper) {
        return MapBuilder.newBuilder().add((Object)"custom", (Object)i18nHelper.getText("admin.mailservers.custom")).add((Object)"gmail-smtp", (Object)"Google Apps Mail / Gmail").add((Object)"yahooplus-smtp", (Object)"Yahoo! Mail Plus").toLinkedHashMap();
    }

    public AddSmtpMailServer(NotificationSchemeManager notificationSchemeManager) {
        this.notificationSchemeManager = notificationSchemeManager;
    }

    @Override
    public String doDefault() throws Exception {
        this.projects = Sets.newTreeSet((Comparator)new Comparator<Project>(){

            @Override
            public int compare(Project p1, Project p2) {
                return p1.getName().compareToIgnoreCase(p2.getName());
            }
        });
        for (Scheme scheme : this.notificationSchemeManager.getSchemeObjects()) {
            this.projects.addAll(this.notificationSchemeManager.getProjects(scheme));
        }
        return super.doDefault();
    }

    public Collection<Project> getProjects() {
        return this.projects;
    }

    @Override
    public Map<String, String> getSupportedServiceProviders() {
        return AddSmtpMailServer.getSupportedServiceProviders((I18nHelper)this);
    }

    @Override
    public String getActiveTab() {
        return "outgoing_mail";
    }

    @Override
    public String getCancelURI() {
        return "OutgoingMailServers.jspa";
    }
}

