/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.mail.webwork.MailServerActionSupport;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.impl.PopMailServerImpl;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public abstract class AddMailServer
extends MailServerActionSupport {
    private String provider;

    public AddMailServer() {
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("com.atlassian.jira.jira-mail-plugin:verifymailserverconnection");
        webResourceManager.requireResource("com.atlassian.jira.jira-mail-plugin:mail-servers");
    }

    @Override
    public String doDefault() throws Exception {
        this.setTimeout(10000L);
        return "input";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        PopMailServerImpl mailServer;
        MailProtocol protocol = MailProtocol.getMailProtocol((String)this.getProtocol());
        if (this.getTimeout() == null) {
            this.setTimeout(10000L);
        }
        String port = StringUtils.isNotBlank((String)this.getPort()) ? this.getPort() : protocol.getDefaultPort();
        if (this.getTypes()[0].equals(this.getType())) {
            if (!this.canAddPopMailServer()) return "securitybreach";
            mailServer = new PopMailServerImpl(null, this.getName(), this.getDescription(), protocol, this.getServerName(), port, this.getUsername(), this.getPassword(), this.getTimeout().longValue());
        } else {
            if (!this.getTypes()[1].equals(this.getType())) return "error";
            if (!this.canAddSmtpMailServer()) return "securitybreach";
            mailServer = StringUtils.isNotBlank((String)this.getJndiLocation()) ? new SMTPMailServerImpl(null, this.getName(), this.getDescription(), this.getFrom(), this.getPrefix(), true, protocol, this.getJndiLocation(), port, this.isTlsRequired(), this.getUsername(), this.getPassword(), this.getTimeout().longValue()) : new SMTPMailServerImpl(null, this.getName(), this.getDescription(), this.getFrom(), this.getPrefix(), false, protocol, this.getServerName(), port, this.isTlsRequired(), this.getUsername(), this.getPassword(), this.getTimeout().longValue());
        }
        this.configureSocks((MailServer)mailServer);
        ComponentAccessor.getMailServerManager().create((MailServer)mailServer);
        return this.getRedirect(this.getCancelURI());
    }

    private boolean canAddSmtpMailServer() {
        return this.canManageSmtpMailServers();
    }

    private boolean canAddPopMailServer() {
        return this.canManagePopMailServers();
    }

    public String getServiceProvider() {
        return this.provider;
    }

    public void setServiceProvider(String provider) {
        this.provider = provider;
    }

    public abstract Map<String, String> getSupportedServiceProviders();

    public abstract String getCancelURI();
}

