/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.rest;

import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.plugins.mail.rest.OutgoingMailConfig;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
@Path(value="outgoingMail")
@Consumes(value={"application/json"})
public class OutgoingMailResource {
    private static final Logger log = LoggerFactory.getLogger(OutgoingMailResource.class);
    private final MailSettings.Send outgoingMailSetting;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;

    public OutgoingMailResource(MailSettings outgoingMailSetting, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.outgoingMailSetting = outgoingMailSetting.send();
    }

    @PUT
    @Path(value="config")
    public void setConfig(OutgoingMailConfig config) {
        log.debug("Received outgoing mail configuration", (Object)config);
        ApplicationUser user = this.authenticationContext.getUser();
        boolean isAdmin = this.permissionManager.hasPermission(0, user);
        boolean isSysadmin = this.permissionManager.hasPermission(44, user);
        if (!isAdmin && !isSysadmin) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (config.enabled) {
            this.outgoingMailSetting.enable();
        } else {
            this.outgoingMailSetting.disable();
        }
    }
}

