/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.internal;

import com.atlassian.jira.plugins.mail.extensions.ParamsFormatter;
import com.atlassian.jira.plugins.mail.webwork.EditHandlerDetailsWebAction;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.lang.Pair;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DefaultParamsFormatter
implements ParamsFormatter {
    protected final JiraAuthenticationContext authenticationContext;
    protected final UserKeyService userKeyService;

    public DefaultParamsFormatter(JiraAuthenticationContext authenticationContext, UserKeyService userKeyService) {
        this.authenticationContext = authenticationContext;
        this.userKeyService = userKeyService;
    }

    @Override
    public Pair<String, String> formatParam(String key, String value) {
        if (key == null || key.equals("project") || key.equals("issuetype")) {
            return null;
        }
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        Map<String, String> defaults = EditHandlerDetailsWebAction.getFieldLabels();
        if (key.equals("reporteruserkey")) {
            return Pair.of((Object)i18n.getText(defaults.get("reporterusername")), (Object)this.formattedUserNameForKey(value));
        }
        return Pair.of((Object)StringUtils.defaultString((String)i18n.getText(defaults.get(key)), (String)key), (Object)value);
    }

    private String formattedUserNameForKey(String userKeyValue) {
        if (userKeyValue == null) {
            return "Unknown User";
        }
        String userName = this.userKeyService.getUsernameForKey(userKeyValue);
        return userName != null ? userName : userKeyValue;
    }
}

