/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.internal;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.mail.internal.LoopDetection;
import com.atlassian.jira.plugins.mail.internal.LoopDetectionDao;
import com.atlassian.sal.api.transaction.TransactionCallback;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultLoopDetectionDao
implements LoopDetectionDao {
    protected ActiveObjects activeObjects;
    private Duration duration = Duration.standardMinutes((long)15L);

    @Override
    public int getTimeLimitInSeconds() {
        return this.duration.toStandardSeconds().getSeconds();
    }

    @Override
    public long getTimeLimitInMillis() {
        return this.duration.getMillis();
    }

    @Override
    public void setTimeLimitInMillis(long millis) {
        this.duration = Duration.millis((long)millis);
    }

    @Autowired
    public DefaultLoopDetectionDao(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Override
    public void deleteAll() {
        this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                DefaultLoopDetectionDao.this.activeObjects.deleteWithSQL(LoopDetection.class, "1=1", new Object[0]);
                return null;
            }
        });
    }

    @Override
    public int getCount(final String sender) {
        return (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer doInTransaction() {
                DefaultLoopDetectionDao.this.deleteExpiredEntries();
                LoopDetection[] rows = (LoopDetection[])DefaultLoopDetectionDao.this.activeObjects.find(LoopDetection.class, Query.select().where("SENDER_EMAIL LIKE ?", new Object[]{sender}));
                if (rows.length > 0) {
                    return rows[0].getCounter();
                }
                DefaultLoopDetectionDao.this.createLoopDetection(sender, 0);
                return 0;
            }
        });
    }

    protected void createLoopDetection(String sender, int count) {
        this.activeObjects.create(LoopDetection.class, new DBParam[]{new DBParam("SENDER_EMAIL", (Object)sender), new DBParam("EXPIRES_AT", (Object)this.getExpiresAt()), new DBParam("COUNTER", (Object)count)});
    }

    protected void deleteExpiredEntries() {
        long now = new DateTime().toInstant().getMillis();
        Query query = Query.select().where("EXPIRES_AT < ?", new Object[]{now}).order("EXPIRES_AT").limit(50000);
        LoopDetection[] entries = (LoopDetection[])this.activeObjects.find(LoopDetection.class, query);
        if (entries != null && entries.length > 0) {
            this.activeObjects.delete((RawEntity[])entries);
        }
    }

    @Override
    public int getCountAndIncrement(final String sender) {
        return (Integer)this.activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer doInTransaction() {
                DefaultLoopDetectionDao.this.deleteExpiredEntries();
                LoopDetection[] rows = (LoopDetection[])DefaultLoopDetectionDao.this.activeObjects.find(LoopDetection.class, Query.select().where("SENDER_EMAIL LIKE ?", new Object[]{sender}));
                if (rows.length > 0) {
                    int count = rows[0].getCounter();
                    rows[0].setCounter(count + 1);
                    rows[0].setExpiresAt(DefaultLoopDetectionDao.this.getExpiresAt());
                    rows[0].save();
                    return count;
                }
                DefaultLoopDetectionDao.this.createLoopDetection(sender, 1);
                return 0;
            }
        });
    }

    protected long getExpiresAt() {
        return new DateTime().plusSeconds(this.getTimeLimitInSeconds()).toInstant().getMillis();
    }
}

