/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.handlers;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.JiraApplicationContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.SummarySystemField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.mail.MailThreadManager;
import com.atlassian.jira.plugin.assignee.AssigneeResolver;
import com.atlassian.jira.plugins.mail.handlers.AbstractMessageHandler;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerErrorCollector;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.service.util.handler.MessageUserProcessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.MailUtils;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class CreateIssueHandler
extends AbstractMessageHandler {
    public static final String KEY_PROJECT = "project";
    public static final String KEY_ISSUETYPE = "issuetype";
    public static final String CC_ASSIGNEE = "ccassignee";
    public static final String CC_WATCHER = "ccwatcher";
    public String projectKey;
    public String issueType;
    public static final boolean DEFAULT_CC_ASSIGNEE = true;
    public boolean ccAssignee = true;
    public boolean ccWatcher = false;

    public CreateIssueHandler() {
    }

    @VisibleForTesting
    CreateIssueHandler(PermissionManager permissionManager, IssueUpdater issueUpdater, UserManager userManager, ApplicationProperties applicationProperties, JiraApplicationContext jiraApplicationContext, MailLoggingManager mailLoggingManager, MessageUserProcessor messageUserProcessor) {
        super(userManager, applicationProperties, jiraApplicationContext, mailLoggingManager, messageUserProcessor, permissionManager);
    }

    @Override
    public void init(Map<String, String> params, MessageHandlerErrorCollector errorCollector) {
        this.log.debug((Object)("CreateIssueHandler.init(params: " + params + ")"));
        super.init(params, errorCollector);
        if (params.containsKey(KEY_PROJECT)) {
            this.projectKey = params.get(KEY_PROJECT);
        }
        if (params.containsKey(KEY_ISSUETYPE)) {
            this.issueType = params.get(KEY_ISSUETYPE);
        }
        if (params.containsKey(CC_ASSIGNEE)) {
            this.ccAssignee = Boolean.valueOf(params.get(CC_ASSIGNEE));
        }
        if (params.containsKey(CC_WATCHER)) {
            this.ccWatcher = Boolean.valueOf(params.get(CC_WATCHER));
        }
    }

    @Override
    public boolean handleMessage(Message message, MessageHandlerContext context) throws MessagingException {
        Issue issue;
        ApplicationUser reporter;
        this.log.debug((Object)"CreateIssueHandler.handleMessage");
        if (!this.canHandleMessage(message, context.getMonitor())) {
            return this.deleteEmail;
        }
        try {
            reporter = this.getReporter(message, context);
            if (reporter == null) {
                String error = this.getI18nBean().getText("admin.mail.no.default.reporter");
                context.getMonitor().warning(error);
                context.getMonitor().messageRejected(message, error);
                return false;
            }
            Project project = this.getProject(message);
            this.log.debug((Object)("Project = " + project));
            if (project == null) {
                String text = this.getI18nBean().getText("admin.mail.no.project.configured");
                context.getMonitor().warning(text);
                context.getMonitor().messageRejected(message, text);
                return false;
            }
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            I18nBean i18nHelper = new I18nBean(Locale.ENGLISH);
            this.getIssueCreationHelperBean().validateLicense(reporter, (ErrorCollection)errorCollection, (I18nHelper)i18nHelper);
            if (errorCollection.hasAnyErrors()) {
                context.getMonitor().warning(this.getI18nBean().getText("admin.mail.bad.license", errorCollection.getErrorMessages().toString()));
                return false;
            }
            if (!this.getPermissionManager().hasPermission(11, project, reporter, true) && reporter.getDirectoryId() != -1L) {
                String error = this.getI18nBean().getText("admin.mail.no.create.permission", reporter.getName());
                context.getMonitor().warning(error);
                context.getMonitor().messageRejected(message, error);
                return false;
            }
            this.log.debug((Object)("Issue Type Key = " + this.issueType));
            if (!this.hasValidIssueType()) {
                context.getMonitor().warning(this.getI18nBean().getText("admin.mail.invalid.issue.type"));
                return false;
            }
            String summary = message.getSubject();
            if (!TextUtils.stringSet((String)summary)) {
                context.getMonitor().markMessageForDeletion(this.getI18nBean().getText("admin.mail.no.subject"));
                return false;
            }
            if (summary.length() > SummarySystemField.MAX_LEN.intValue()) {
                context.getMonitor().info("Truncating summary field because it is too long: " + summary);
                summary = summary.substring(0, SummarySystemField.MAX_LEN.intValue() - 3) + "...";
            }
            String priority = null;
            String description = null;
            if (!this.getFieldVisibilityManager().isFieldHiddenInAllSchemes(project.getId(), "priority", Collections.singletonList(this.issueType))) {
                priority = this.getPriority(message);
            }
            if (!this.getFieldVisibilityManager().isFieldHiddenInAllSchemes(project.getId(), "description", Collections.singletonList(this.issueType))) {
                description = this.getDescription(reporter, message);
            }
            ApplicationUser assignee = null;
            if (this.ccAssignee) {
                assignee = CreateIssueHandler.getFirstValidAssignee(message.getAllRecipients(), project);
            }
            if (assignee == null) {
                assignee = this.getProjectManager().getDefaultAssignee(project, (Collection)Collections.EMPTY_SET);
            }
            MutableIssue issueObject = this.getIssueFactory().getIssue();
            issueObject.setProjectObject(project);
            issueObject.setSummary(summary);
            issueObject.setDescription(description);
            issueObject.setIssueTypeId(this.issueType);
            issueObject.setReporter(reporter);
            if (assignee != null) {
                issueObject.setAssignee(assignee);
            }
            issueObject.setPriorityId(priority);
            this.setDefaultSecurityLevel(issueObject);
            HashMap<String, MutableIssue> fields = new HashMap<String, MutableIssue>();
            fields.put("issue", issueObject);
            MutableIssue originalIssue = this.getIssueManager().getIssueObject(issueObject.getId());
            List customFieldObjects = ComponentAccessor.getCustomFieldManager().getCustomFieldObjects((Issue)issueObject);
            for (CustomField customField : customFieldObjects) {
                issueObject.setCustomFieldValue(customField, customField.getDefaultValue((Issue)issueObject));
            }
            fields.put("originalissueobject", originalIssue);
            issue = context.createIssue(reporter, (Issue)issueObject);
            this.mauEventService.setApplicationForThreadBasedOnProject(project);
        }
        catch (Exception e) {
            context.getMonitor().warning(this.getI18nBean().getText("admin.mail.unable.to.create.issue"), (Throwable)e);
            return false;
        }
        this.addCcWatchersAndAttachments(message, context, issue, reporter);
        return true;
    }

    @VisibleForTesting
    void addCcWatchersAndAttachments(Message message, MessageHandlerContext context, Issue issue, ApplicationUser reporter) {
        try {
            if (issue != null) {
                if (this.ccWatcher) {
                    this.addCcWatchersToIssue(message, issue, reporter, context, context.getMonitor());
                }
                this.recordIncomingMessageId(MailThreadManager.MailAction.ISSUE_CREATED_FROM_EMAIL, message, issue, context);
                this.createAttachmentsForMessage(message, issue, context);
            }
        }
        catch (AddressException ae) {
            this.addCommentIndicatingWatcherFailureAndMarkForDeletion(issue, context);
        }
        catch (MessagingException me) {
            this.addCommentIndicatingAttachmentFailureAndMarkForDeletion(issue, context, (Exception)((Object)me));
        }
        catch (IOException ie) {
            this.addCommentIndicatingAttachmentFailureAndMarkForDeletion(issue, context, ie);
        }
    }

    @VisibleForTesting
    void addCommentIndicatingWatcherFailureAndMarkForDeletion(Issue issue, MessageHandlerContext context) {
        context.createComment(issue, null, this.getI18nBean().getText("jmp.handler.watchers.failed"), true);
        context.getMonitor().markMessageForDeletion(this.getI18nBean().getText("jmp.handler.watchers.failed"));
    }

    private IssueCreationHelperBean getIssueCreationHelperBean() {
        return (IssueCreationHelperBean)ComponentAccessor.getComponent(IssueCreationHelperBean.class);
    }

    PermissionManager getPermissionManager() {
        return ComponentAccessor.getPermissionManager();
    }

    FieldVisibilityManager getFieldVisibilityManager() {
        return (FieldVisibilityManager)ComponentAccessor.getComponent(FieldVisibilityManager.class);
    }

    AssigneeResolver getAssigneeResolver() {
        return (AssigneeResolver)ComponentAccessor.getComponent(AssigneeResolver.class);
    }

    IssueManager getIssueManager() {
        return ComponentAccessor.getIssueManager();
    }

    IssueFactory getIssueFactory() {
        return ComponentAccessor.getIssueFactory();
    }

    public void addCcWatchersToIssue(Message message, Issue issue, ApplicationUser reporter, MessageHandlerContext context, MessageHandlerExecutionMonitor messageHandlerExecutionMonitor) throws MessagingException {
        Collection<ApplicationUser> users = this.getAllUsersFromEmails(message.getAllRecipients());
        users.remove(reporter);
        if (!users.isEmpty()) {
            if (context.isRealRun()) {
                Issue updatedIssue = issue;
                for (ApplicationUser user : users) {
                    updatedIssue = this.getWatcherManager().startWatching(user, updatedIssue);
                }
            } else {
                String watchers = StringUtils.join(users, (String)",");
                messageHandlerExecutionMonitor.info("Adding watchers " + watchers);
                this.log.debug((Object)("Watchers [" + watchers + "] not added due to dry-run mode."));
            }
        }
    }

    WatcherManager getWatcherManager() {
        return (WatcherManager)ComponentManager.getComponentInstanceOfType(WatcherManager.class);
    }

    public Collection<ApplicationUser> getAllUsersFromEmails(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ApplicationUser> users = new ArrayList<ApplicationUser>();
        for (Address address : addresses) {
            ApplicationUser user;
            String emailAddress = this.getEmailAddress(address);
            if (emailAddress == null || (user = UserUtils.getUserByEmail((String)emailAddress)) == null) continue;
            users.add(user);
        }
        return users;
    }

    private String getEmailAddress(Address address) {
        if (address instanceof InternetAddress) {
            InternetAddress internetAddress = (InternetAddress)address;
            return internetAddress.getAddress();
        }
        return null;
    }

    protected Project getProject(Message message) {
        if (this.projectKey == null) {
            this.log.debug((Object)"Project key NOT set. Cannot find project.");
            return null;
        }
        this.log.debug((Object)("Project key = " + this.projectKey));
        return this.getProjectManager().getProjectObjByKey(this.projectKey.toUpperCase(Locale.getDefault()));
    }

    protected boolean hasValidIssueType() {
        if (this.issueType == null) {
            this.log.debug((Object)"Issue Type NOT set. Cannot find Issue type.");
            return false;
        }
        IssueType issueTypeObject = this.getConstantsManager().getIssueTypeObject(this.issueType);
        if (issueTypeObject == null) {
            this.log.debug((Object)("Issue Type with does not exist with id of " + this.issueType));
            return false;
        }
        this.log.debug((Object)("Issue Type Object = " + issueTypeObject.getName()));
        return true;
    }

    protected ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }

    private String getDescription(ApplicationUser reporter, Message message) throws MessagingException {
        return this.recordFromAddressForAnon(reporter, message, MailUtils.getBody((Message)message));
    }

    @VisibleForTesting
    String recordFromAddressForAnon(ApplicationUser reporter, Message message, String description) throws MessagingException {
        if (this.reporteruserName != null && this.reporteruserName.equalsIgnoreCase(reporter.getName())) {
            description = description + "\n[Created via e-mail ";
            description = message.getFrom() != null && message.getFrom().length > 0 ? description + "received from: " + message.getFrom()[0] + "]" : description + "but could not establish sender's address.]";
        }
        return description;
    }

    private String getPriority(Message message) throws MessagingException {
        String[] xPrioHeaders = message.getHeader("X-Priority");
        if (xPrioHeaders != null && xPrioHeaders.length > 0) {
            String xPrioHeader = xPrioHeaders[0];
            int priorityValue = Integer.parseInt(TextUtils.extractNumber((String)xPrioHeader));
            if (priorityValue == 0) {
                return this.getDefaultSystemPriority();
            }
            Collection priorities = this.getConstantsManager().getPriorityObjects();
            Iterator priorityIt = priorities.iterator();
            int priorityNumber = (int)Math.ceil((double)priorityValue / 5.0 * (double)priorities.size());
            if (priorityNumber > priorities.size()) {
                priorityNumber = priorities.size();
            }
            String priority = null;
            for (int i = 0; i < priorityNumber; ++i) {
                priority = ((Priority)priorityIt.next()).getId();
            }
            return priority;
        }
        return this.getDefaultSystemPriority();
    }

    ConstantsManager getConstantsManager() {
        return (ConstantsManager)ComponentManager.getComponentInstanceOfType(ConstantsManager.class);
    }

    private String getDefaultSystemPriority() {
        Priority defaultPriority = this.getConstantsManager().getDefaultPriorityObject();
        if (defaultPriority == null) {
            this.log.warn((Object)"Default priority was null. Using the 'middle' priority.");
            Collection priorities = this.getConstantsManager().getPriorityObjects();
            int times = (int)Math.ceil((double)priorities.size() / 2.0);
            Iterator priorityIt = priorities.iterator();
            for (int i = 0; i < times; ++i) {
                defaultPriority = (Priority)priorityIt.next();
            }
        }
        if (defaultPriority == null) {
            throw new RuntimeException("Default priority not found");
        }
        return defaultPriority.getId();
    }

    public static ApplicationUser getFirstValidAssignee(Address[] addresses, Project project) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        for (Address address : addresses) {
            InternetAddress email;
            ApplicationUser validUser;
            if (!(address instanceof InternetAddress) || (validUser = UserUtils.getUserByEmail((String)(email = (InternetAddress)address).getAddress())) == null || !((PermissionManager)ComponentManager.getComponentInstanceOfType(PermissionManager.class)).hasPermission(17, project, validUser)) continue;
            return validUser;
        }
        return null;
    }

    private void setDefaultSecurityLevel(MutableIssue issue) throws Exception {
        Long levelId;
        GenericValue project = issue.getProject();
        if (project != null && (levelId = this.getIssueSecurityLevelManager().getSchemeDefaultSecurityLevel(project)) != null) {
            issue.setSecurityLevel(this.getIssueSecurityLevelManager().getIssueSecurity(levelId));
        }
    }

    IssueSecurityLevelManager getIssueSecurityLevelManager() {
        return (IssueSecurityLevelManager)ComponentManager.getComponentInstanceOfType(IssueSecurityLevelManager.class);
    }

    @Override
    protected boolean attachPlainTextParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part) && MailUtils.isPartAttachment((Part)part);
    }

    @Override
    protected boolean attachHtmlParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part) && MailUtils.isPartAttachment((Part)part);
    }
}

