/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.handlers;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.MailThreadManager;
import com.atlassian.jira.plugins.mail.handlers.AbstractMessageHandler;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.mail.MailUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.apache.log4j.Logger;

public class CVSLogHandler
extends AbstractMessageHandler {
    private static final Logger log = Logger.getLogger(CVSLogHandler.class);
    private static final String COMMENT_START_LINE = "Log Message:";
    private static final String COMMENT_END_LINE_1 = "Index:";
    private static final String COMMENT_END_LINE_2 = "===================================================================";
    private static final String COMMENT_2_END_LINE = "--- NEW FILE:";
    private static final String COMMENT_3_END_LINE = "DELETED ---";

    @Override
    public boolean handleMessage(Message message, MessageHandlerContext context) throws MessagingException {
        if (!this.canHandleMessage(message, context.getMonitor())) {
            return this.deleteEmail;
        }
        String messageBody = MailUtils.getBody((Message)message);
        String commentArea = this.getCommentArea(messageBody);
        ApplicationUser reporter = this.getReporter(message, context);
        if (reporter == null) {
            log.warn((Object)"The mail 'FROM' does not match a valid user");
            log.warn((Object)("This user is not in jira so can not add a comment: " + message.getFrom()[0]));
            return false;
        }
        Iterable issues = ServiceUtils.findIssueObjectsInString((String)commentArea);
        for (Issue issue : issues) {
            try {
                if (this.hasUserPermissionToComment(issue, reporter)) {
                    String commentBody = this.createCommentBody(message.getSubject(), commentArea);
                    context.createComment(issue, reporter, commentBody, true);
                } else {
                    context.getMonitor().warning("You (" + reporter.getDisplayName() + ") do not have permission to comment on an issue in project: " + issue.getProjectObject().getId());
                }
                this.recordIncomingMessageId(MailThreadManager.MailAction.ISSUE_COMMENTED_FROM_EMAIL, message, issue, context);
            }
            catch (RuntimeException e) {
                log.warn((Object)("Exception creating comment " + e.getMessage()), (Throwable)e);
            }
        }
        return true;
    }

    private String createCommentBody(String subject, String commentArea) {
        StringBuilder commentBody = new StringBuilder(32);
        commentBody.append("CVS COMMIT LOG: \n");
        if (subject != null) {
            commentBody.append("SUBJECT: ").append(subject).append("\n");
        }
        commentBody.append(commentArea);
        return commentBody.toString();
    }

    protected boolean hasUserPermissionToComment(Issue issue, ApplicationUser reporter) {
        return ComponentAccessor.getPermissionManager().hasPermission(15, issue, reporter);
    }

    public String getCommentArea(String messageBody) {
        if (messageBody == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new StringReader(messageBody));
        boolean insideComment = false;
        StringBuilder comment = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!insideComment) {
                    if (line.toLowerCase().startsWith(COMMENT_START_LINE.toLowerCase())) {
                        insideComment = true;
                    }
                } else {
                    if (line.startsWith(COMMENT_2_END_LINE) || line.endsWith(COMMENT_3_END_LINE) || line.endsWith(COMMENT_END_LINE_2)) {
                        insideComment = false;
                        return comment.toString();
                    }
                    if (line.startsWith(COMMENT_END_LINE_1)) {
                        String line2 = reader.readLine();
                        if (line2 != null) {
                            if (line2.startsWith(COMMENT_END_LINE_2)) {
                                insideComment = false;
                                return comment.toString();
                            }
                            comment.append(line);
                            comment.append("\n");
                            comment.append(line2);
                            comment.append("\n");
                        }
                    } else {
                        comment.append(line);
                        comment.append("\n");
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            log.warn((Object)("IOException reading Mail body: " + e.getMessage()), (Throwable)e);
        }
        if (insideComment) {
            log.warn((Object)("UnClosed Comment Tag!  Not adding comment: [" + comment.substring(0, 15) + "]"));
        }
        return null;
    }

    @Override
    protected boolean attachPlainTextParts(Part part) throws MessagingException, IOException {
        return false;
    }

    @Override
    protected boolean attachHtmlParts(Part part) throws MessagingException, IOException {
        return false;
    }
}

