/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.extensions;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.plugins.mail.extensions.MessageHandlerValidator;
import com.atlassian.jira.plugins.mail.extensions.ParamsFormatter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.module.ModuleFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dom4j.Element;

public class MessageHandlerModuleDescriptor
extends AbstractJiraModuleDescriptor<MessageHandler>
implements StateAware {
    private Class<? extends MessageHandler> messageHandler;
    private String addEditUrl;
    private final ComponentClassManager componentClassManager;
    private int weight = Integer.MAX_VALUE;
    private volatile MessageHandlerValidator validator;
    private volatile ParamsFormatter paramsFormatter;
    private String validatorClassStr;
    private String paramsFormatterClassStr;

    public MessageHandlerModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
        this.componentClassManager = this.getComponentClassManager();
    }

    @Nonnull
    protected ComponentClassManager getComponentClassManager() {
        return ComponentAccessor.getComponentClassManager();
    }

    public void enabled() {
        super.enabled();
        if (this.validatorClassStr != null) {
            try {
                this.validator = (MessageHandlerValidator)this.componentClassManager.newInstance(this.validatorClassStr);
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException("Cannot instantiate message-handler validator class '" + this.validatorClassStr + "'", (Throwable)e);
            }
        }
        if (this.paramsFormatterClassStr != null) {
            try {
                this.paramsFormatter = (ParamsFormatter)this.componentClassManager.newInstance(this.paramsFormatterClassStr);
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException("Cannot instantiate message-handler params formatter class '" + this.paramsFormatterClassStr + "'", (Throwable)e);
            }
        }
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        String messageHandlerClass = element.attributeValue("class");
        try {
            this.messageHandler = this.componentClassManager.loadClass(messageHandlerClass);
        }
        catch (ClassNotFoundException e) {
            throw new PluginParseException("Cannot load message-handler class '" + messageHandlerClass + "'", (Throwable)e);
        }
        this.addEditUrl = element.attributeValue("add-edit-url");
        this.validatorClassStr = element.attributeValue("validator-class");
        this.paramsFormatterClassStr = element.attributeValue("params-formatter-class");
        String weightString = element.attributeValue("weight");
        if (weightString != null) {
            try {
                this.weight = Integer.valueOf(weightString);
            }
            catch (NumberFormatException e) {
                throw new PluginParseException(String.format("Invalid value for weight, must be an integer: %s", this.weight), (Throwable)e);
            }
        }
    }

    public void disabled() {
        this.validator = null;
        super.disabled();
    }

    public Class<? extends MessageHandler> getMessageHandler() {
        return this.messageHandler;
    }

    @Nullable
    public MessageHandlerValidator getValidator() {
        return this.validator;
    }

    @Nullable
    public ParamsFormatter getParamsFormatter() {
        return this.paramsFormatter;
    }

    public String getAddEditUrl() {
        return this.addEditUrl;
    }

    public int getWeight() {
        return this.weight;
    }
}

