/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail;

import com.atlassian.jira.plugins.mail.extensions.MessageHandlerModuleDescriptor;
import com.atlassian.jira.service.services.file.FileService;
import com.atlassian.jira.service.services.mail.MailFetcherService;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.mail.MailException;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServiceConfiguration {
    public static final String ID = ServiceConfiguration.class.getName();
    private String handlerKey;
    private String serviceName;
    private long delay;
    private String folder;
    private Long serverId;
    private Long serviceId;

    @Nullable
    public Long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(@Nullable Long serviceId) {
        this.serviceId = serviceId;
    }

    public void setHandlerKey(@Nonnull String handler) {
        this.handlerKey = handler;
    }

    @Nonnull
    public String getHandlerKey() {
        return this.handlerKey;
    }

    @Nonnull
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(@Nonnull String serviceName) {
        this.serviceName = serviceName;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setFolder(@Nullable String folder) {
        this.folder = folder;
    }

    @Nullable
    public String getFolder() {
        return this.folder;
    }

    public void setServerId(@Nullable Long serverId) {
        this.serverId = serverId;
    }

    @Nullable
    public Long getServerId() {
        return this.serverId;
    }

    @Nonnull
    public Map<String, String[]> toServiceParams(@Nonnull PluginAccessor pa) throws MailException {
        return Maps.transformValues(this.toMap(pa), (Function)new Function<String, String[]>(){

            public String[] apply(@Nullable String from) {
                return new String[]{from};
            }
        });
    }

    @Nonnull
    public Map<String, String> toMap(@Nonnull PluginAccessor pa) throws MailException {
        MapBuilder builder = MapBuilder.newBuilder();
        MessageHandlerModuleDescriptor enabledPluginModule = (MessageHandlerModuleDescriptor)pa.getEnabledPluginModule(this.getHandlerKey());
        if (enabledPluginModule != null) {
            builder.add((Object)"handler", (Object)enabledPluginModule.getMessageHandler().getName());
        }
        if (this.getServerId() != null) {
            builder.add((Object)"popserver", (Object)Long.toString(this.getServerId())).add((Object)"foldername", (Object)this.getFolder());
        } else {
            builder.add((Object)"subdirectory", (Object)this.getFolder());
        }
        return builder.toMutableMap();
    }

    @Nonnull
    public String getServiceClass() {
        return (this.serverId == null ? FileService.class : MailFetcherService.class).getName();
    }
}

