/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail;

import com.atlassian.configurable.ValuesGenerator;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.PopMailServer;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ImapServersValuesGenerator
implements ValuesGenerator {
    public Map<String, String> getValues(Map params) {
        HashMap returnValues = Maps.newHashMap();
        Iterable mailServers = Iterables.filter((Iterable)this.getMailServerManager().getPopMailServers(), this.getPredicate());
        for (PopMailServer mailServer : mailServers) {
            returnValues.put(mailServer.getId().toString(), mailServer.getName());
        }
        return returnValues;
    }

    protected MailServerManager getMailServerManager() {
        return MailFactory.getServerManager();
    }

    protected Predicate<? super PopMailServer> getPredicate() {
        return new Predicate<PopMailServer>(){

            public boolean apply(@Nullable PopMailServer input) {
                return input != null && (input.getMailProtocol().equals((Object)MailProtocol.SECURE_IMAP) || input.getMailProtocol().equals((Object)MailProtocol.IMAP));
            }
        };
    }
}

