/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail;

import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import javax.mail.Message;

public class DryRunMessageHandlerExecutionMonitor
implements MessageHandlerExecutionMonitor {
    private final List<String> dryRunMessages = Lists.newArrayList();
    private final List<String> errorMessages = Lists.newArrayList();
    private int numMessages;
    private int numMessagesRejected;

    public void error(String error, @Nullable Throwable e) {
        String s = error + (e != null ? ": " + e.getMessage() : "");
        this.dryRunMessages.add(s);
        this.errorMessages.add(s);
    }

    public void error(String error) {
        this.dryRunMessages.add(error);
        this.errorMessages.add(error);
    }

    public void info(String info) {
        this.dryRunMessages.add(info);
    }

    public void info(String info, @Nullable Throwable e) {
        this.dryRunMessages.add(info + (e != null ? ": " + e.getMessage() : ""));
    }

    public void warning(String warning) {
        this.error(warning);
    }

    public void warning(String warning, @Nullable Throwable e) {
        this.error(warning, e);
    }

    public boolean hasErrors() {
        return !this.errorMessages.isEmpty();
    }

    public void messageRejected(Message message, String reason) {
        ++this.numMessagesRejected;
    }

    public void nextMessage(Message message) {
    }

    public void markMessageForDeletion(String reason) {
        this.error(reason);
    }

    public List<String> getAllMessages() {
        return this.dryRunMessages;
    }

    public void setNumMessages(int count) {
        this.numMessages = count;
    }

    public int getNumMessages() {
        return this.numMessages;
    }

    public int getNumMessagesRejected() {
        return this.numMessagesRejected;
    }

    public Iterable<String> getErrorMessages() {
        return this.errorMessages;
    }
}

