/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel.upload;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.lookandfeel.ImageScaler;
import com.atlassian.jira.lookandfeel.image.ImageDescriptor;
import com.atlassian.jira.lookandfeel.upload.LogoUploader;
import com.atlassian.jira.lookandfeel.upload.UploadService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class UploadServiceImpl
implements UploadService {
    private final ImageScaler imageScaler;
    private final JiraHome jiraHome;
    private final ApplicationProperties applicationProperties;
    private final PluginSettings globalSettings;
    private final JiraAuthenticationContext authenticationContex;

    public UploadServiceImpl(ImageScaler imageScaler, JiraHome jiraHome, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PluginSettingsFactory globalSettingsFactory) {
        this.imageScaler = imageScaler;
        this.jiraHome = jiraHome;
        this.applicationProperties = applicationProperties;
        this.globalSettings = globalSettingsFactory.createGlobalSettings();
        this.authenticationContex = authenticationContext;
    }

    @Override
    public List<String> uploadLogo(ImageDescriptor imageDescriptor, LookAndFeelBean lookAndFeelBean) {
        LogoUploader logoUploader = new LogoUploader(this.applicationProperties, this.jiraHome, this.imageScaler, this.authenticationContex.getI18nHelper(), this);
        if (logoUploader.validate(imageDescriptor)) {
            String logoUrl = logoUploader.saveLogo(imageDescriptor.getInputStream(), "jira-logo-original.png", "jira-logo-scaled.png");
            String width = Integer.toString(logoUploader.getResizedWidth());
            String height = Integer.toString(logoUploader.getResizedHeight());
            lookAndFeelBean.setLogoWidth(width);
            lookAndFeelBean.setLogoHeight(height);
            lookAndFeelBean.setLogoUrl(this.ensureUrlCorrect(logoUrl));
            this.globalSettings.put("com.atlassian.jira.lookandfeel:usingCustomLogo", (Object)BooleanUtils.toStringTrueFalse((boolean)true));
        }
        return logoUploader.getErrorMessages();
    }

    @Override
    public List<String> uploadFavicon(LookAndFeelBean lookAndFeelBean, ImageDescriptor imageDescriptor) {
        String faviconUrl;
        LogoUploader logoUploader = new LogoUploader(this.applicationProperties, this.jiraHome, this.imageScaler, this.authenticationContex.getI18nHelper(), this);
        if (logoUploader.validate(imageDescriptor) && StringUtils.isNotBlank((String)(faviconUrl = logoUploader.saveFavicon(imageDescriptor.getInputStream(), "jira-favicon-original.png", "jira-favicon-hires.png", "jira-favicon-scaled.png", "jira-favicon-scaled.ico")))) {
            faviconUrl = this.ensureUrlCorrect(faviconUrl);
            String faviconHiResUrl = "/jira-favicon-hires.png";
            lookAndFeelBean.setFaviconUrl(faviconUrl);
            lookAndFeelBean.setFaviconHiResUrl(faviconHiResUrl);
            this.globalSettings.put("com.atlassian.jira.lookandfeel:usingCustomFavicon", (Object)BooleanUtils.toStringTrueFalse((boolean)true));
        }
        return logoUploader.getErrorMessages();
    }

    @Override
    public File getLogoDirectory() {
        String logoDirectoryName = this.jiraHome.getHomePath() + "/logos";
        File logoDirectory = new File(logoDirectoryName);
        if (!logoDirectory.exists()) {
            logoDirectory.mkdirs();
        }
        return logoDirectory;
    }

    @Override
    public Map<String, String> uploadDefaultFavicon(BufferedImage image) {
        LogoUploader logoUploader = new LogoUploader(this.applicationProperties, this.jiraHome, this.imageScaler, this.authenticationContex.getI18nHelper(), this);
        Dimension dimension = logoUploader.saveDefaultFavicOn(image, "jira-favicon-default.png", "jira-favicon-default-scaled.png");
        this.globalSettings.put("com.atlassian.jira.lookandfeel:isDefaultFavicon", (Object)BooleanUtils.toStringTrueFalse((boolean)true));
        return MapBuilder.newBuilder().add((Object)"path", (Object)"/images/jira-favicon-default-scaled.png").add((Object)"width", (Object)("" + dimension.width)).add((Object)"height", (Object)("" + dimension.height)).toMap();
    }

    @Override
    public Map<String, String> uploadDefaultLogo(BufferedImage image) {
        LogoUploader logoUploader = new LogoUploader(this.applicationProperties, this.jiraHome, this.imageScaler, this.authenticationContex.getI18nHelper(), this);
        Dimension dimensions = logoUploader.saveDefaultLogo(image, "jira-logo-default.png", "jira-logo-default-scaled.png");
        this.globalSettings.put("com.atlassian.jira.lookandfeel:isDefaultLogo", (Object)BooleanUtils.toStringTrueFalse((boolean)true));
        return MapBuilder.newBuilder().add((Object)"path", (Object)"/images/jira-logo-default-scaled.png").add((Object)"width", (Object)("" + dimensions.width)).add((Object)"height", (Object)("" + dimensions.height)).toMap();
    }

    private String ensureUrlCorrect(String url) {
        if (StringUtils.isNotBlank((String)url) && !url.startsWith("http") && !url.startsWith("/")) {
            url = "/" + url;
        }
        return url;
    }
}

