/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel.upload;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.lookandfeel.ImageScaler;
import com.atlassian.jira.lookandfeel.image.ImageDescriptor;
import com.atlassian.jira.lookandfeel.upload.UploadService;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.sf.image4j.codec.ico.ICOEncoder;
import org.apache.commons.lang.StringUtils;

public class LogoUploader {
    private final ApplicationProperties applicationProperties;
    private final JiraHome jiraHome;
    private final ImageScaler imageScaler;
    private final I18nHelper i18nHelper;
    private final UploadService uploadService;
    private int resizedWidth;
    private int resizedHeight;
    private static final int FAVICON_HIRES_SIZE = 32;
    private static final int FAVICON_SIZE = 16;
    private static final String LOGO_OUTPUT_FORMAT = "png";
    private static final List<String> CONTENT_TYPES = Lists.newArrayList((Object[])new String[]{"image/jpeg", "image/gif", "image/png", "image/pjpeg", "image/x-png"});
    private final List<String> errorMessages = Lists.newArrayList();

    public LogoUploader(ApplicationProperties applicationProperties, JiraHome jiraHome, ImageScaler imageScaler, I18nHelper i18nHelper, UploadService uploadService) {
        this.applicationProperties = applicationProperties;
        this.jiraHome = jiraHome;
        this.imageScaler = imageScaler;
        this.i18nHelper = i18nHelper;
        this.uploadService = uploadService;
    }

    private BufferedImage resizeLogo(BufferedImage image) throws IOException {
        BufferedImage scaledImage = this.imageScaler.scaleImageToMaxHeight(image, 30);
        this.resizedWidth = scaledImage.getWidth();
        this.resizedHeight = scaledImage.getHeight();
        return scaledImage;
    }

    private Map<String, BufferedImage> resizeFavicon(BufferedImage image, String hiResFilename, String scaledFilename) throws IOException {
        HashMap favicons = Maps.newHashMap();
        BufferedImage scaledHiResImage = this.imageScaler.scaleImageToSquare(image, 32, true);
        favicons.put(hiResFilename, scaledHiResImage);
        BufferedImage scaledImage = this.imageScaler.scaleImageToSquare(image, 16, true);
        favicons.put(scaledFilename, scaledImage);
        this.resizedWidth = scaledImage.getWidth();
        this.resizedHeight = scaledImage.getHeight();
        return favicons;
    }

    private void writeImageFile(BufferedImage image, String output, String filename) throws IOException {
        File logoDirectory = this.uploadService.getLogoDirectory();
        File logoFile = new File(logoDirectory, filename);
        ImageIO.write((RenderedImage)image, output, logoFile);
    }

    private void writeIEFavicon(List<BufferedImage> images, String ieFaviconFilename) throws IOException {
        File logoDirectory = this.uploadService.getLogoDirectory();
        File logoFile = new File(logoDirectory, ieFaviconFilename);
        ICOEncoder.write(images, (File)logoFile);
    }

    private boolean saveLogoImageData(InputStream imageData, String originalFilename, String rescaledFilename) throws IOException {
        BufferedImage image = ImageIO.read(imageData);
        if (image != null) {
            BufferedImage scaledImage = this.resizeLogo(image);
            this.writeImageFile(scaledImage, LOGO_OUTPUT_FORMAT, rescaledFilename);
            this.writeImageFile(image, LOGO_OUTPUT_FORMAT, originalFilename);
            return true;
        }
        return false;
    }

    private boolean saveFaviconImageData(InputStream imageData, String originalFilename, String hiResFilename, String scaledFilename, String ieFaviconFilename) throws IOException {
        BufferedImage image = ImageIO.read(imageData);
        if (image != null) {
            Map<String, BufferedImage> resizedImages = this.resizeFavicon(image, hiResFilename, scaledFilename);
            for (String path : resizedImages.keySet()) {
                this.writeImageFile(resizedImages.get(path), LOGO_OUTPUT_FORMAT, path);
            }
            this.writeImageFile(image, LOGO_OUTPUT_FORMAT, originalFilename);
            this.writeIEFavicon(new ArrayList<BufferedImage>(resizedImages.values()), ieFaviconFilename);
            return true;
        }
        return false;
    }

    public String saveLogo(InputStream imageData, String originalFilename, String rescaledFilename) {
        try {
            if (this.saveLogoImageData(imageData, originalFilename, rescaledFilename)) {
                return rescaledFilename;
            }
        }
        catch (IOException e) {
            this.errorMessages.add(e.getMessage());
        }
        return null;
    }

    public String saveFavicon(InputStream imageData, String originalFilename, String hiResFilename, String scaledFilename, String ieFaviconFilename) {
        try {
            if (this.saveFaviconImageData(imageData, originalFilename, hiResFilename, scaledFilename, ieFaviconFilename)) {
                return scaledFilename;
            }
        }
        catch (IOException e) {
            this.errorMessages.add(e.getMessage());
        }
        return null;
    }

    public void saveDefaultLogo(URL url, String originalFilename, String scaledFilename) {
        BufferedImage image = null;
        try {
            InputStream imageData = url.openStream();
            image = ImageIO.read(imageData);
            this.saveDefaultLogo(image, originalFilename, scaledFilename);
        }
        catch (IOException e) {
            this.errorMessages.add(e.getMessage());
        }
    }

    public Dimension saveDefaultLogo(BufferedImage image, String originalFilename, String scaledFilename) {
        Dimension dimension = new Dimension(image.getWidth(), image.getHeight());
        try {
            if (image != null) {
                BufferedImage scaledImage = this.imageScaler.scaleImageToMaxHeight(image, 30);
                this.writeImageFile(scaledImage, LOGO_OUTPUT_FORMAT, scaledFilename);
                this.writeImageFile(image, LOGO_OUTPUT_FORMAT, originalFilename);
                dimension.setSize(scaledImage.getWidth(), scaledImage.getHeight());
            }
        }
        catch (IOException e) {
            this.errorMessages.add(e.getMessage());
        }
        return dimension;
    }

    public Dimension saveDefaultFavicOn(BufferedImage image, String originalFilename, String scaledFilename) {
        Dimension dimension = new Dimension(32, 32);
        try {
            if (image != null) {
                BufferedImage scaledImage = this.imageScaler.scaleImageToSquare(image, 32, true);
                this.writeImageFile(scaledImage, LOGO_OUTPUT_FORMAT, scaledFilename);
                this.writeImageFile(image, LOGO_OUTPUT_FORMAT, originalFilename);
            }
        }
        catch (IOException e) {
            this.errorMessages.add(e.getMessage());
        }
        return dimension;
    }

    public int getResizedWidth() {
        return this.resizedWidth;
    }

    public int getResizedHeight() {
        return this.resizedHeight;
    }

    public boolean validate(ImageDescriptor imageDescriptor) {
        if (StringUtils.isNotEmpty((String)imageDescriptor.getImageName())) {
            if (!this.isContentTypeSupported(imageDescriptor.getContentType())) {
                this.addErrorMessage(this.i18nHelper.getText("jira.lookandfeel.upload.error", imageDescriptor.getImageDescriptorType(), imageDescriptor.getImageName()));
                this.addErrorMessage(this.i18nHelper.getText("jira.lookandfeel.upload.mimetype.unsupported", imageDescriptor.getContentType()));
            }
            if (imageDescriptor.getInputStream() == null) {
                this.addErrorMessage(this.i18nHelper.getText("jira.lookandfeel.upload.error", imageDescriptor.getImageDescriptorType(), imageDescriptor.getImageName()));
            }
        } else {
            this.addErrorMessage(this.i18nHelper.getText("jira.lookandfeel.upload.error", imageDescriptor.getImageDescriptorType(), null));
        }
        return this.errorMessages.isEmpty();
    }

    private boolean isContentTypeSupported(String contentType) {
        if (StringUtils.isNotBlank((String)contentType)) {
            final String lowerCaseContentType = contentType.toLowerCase();
            return Iterables.any(CONTENT_TYPES, (Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String validContentType) {
                    return lowerCaseContentType.contains(validContentType);
                }
            });
        }
        return false;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    private void addErrorMessage(String errorMessage) {
        this.errorMessages.add(errorMessage);
    }
}

