/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel.transformer;

import com.atlassian.jira.lookandfeel.LookAndFeelProperties;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.webresource.api.prebake.Coordinate;
import com.atlassian.webresource.api.prebake.DimensionAwareTransformerUrlBuilder;
import com.atlassian.webresource.api.prebake.DimensionAwareWebResourceTransformerFactory;
import com.atlassian.webresource.api.prebake.Dimensions;

public class LogoTransformerFactory
implements DimensionAwareWebResourceTransformerFactory {
    private final LookAndFeelProperties lookAndFeelProperties;
    private final WebResourceUrlProvider webResourceUrlProvider;

    public LogoTransformerFactory(LookAndFeelProperties lookAndFeelProperties, WebResourceUrlProvider provider) {
        this.lookAndFeelProperties = lookAndFeelProperties;
        this.webResourceUrlProvider = provider;
    }

    public Dimensions computeDimensions() {
        return Dimensions.empty();
    }

    public DimensionAwareTransformerUrlBuilder makeUrlBuilder(TransformerParameters transformerParameters) {
        return new DimensionAwareTransformerUrlBuilder(){

            public void addToUrl(UrlBuilder urlBuilder) {
                urlBuilder.addToHash("defaultLogo", (Object)LogoTransformerFactory.this.lookAndFeelProperties.getDefaultCssLogoUrl());
                urlBuilder.addToHash("defaultLogo", (Object)LogoTransformerFactory.this.lookAndFeelProperties.getMaxLogoHeight());
            }

            public void addToUrl(UrlBuilder urlBuilder, Coordinate coord) {
                this.addToUrl(urlBuilder);
            }
        };
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters transformerParameters) {
        return (transformableResource, params) -> new CharSequenceDownloadableResource(transformableResource.nextResource()){

            protected String transform(CharSequence originalContent) {
                String defaultLogoUrl;
                String replacedContent = originalContent.toString();
                String prefix = LogoTransformerFactory.this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.AUTO);
                if ("/".equals(prefix)) {
                    prefix = "";
                }
                if ((defaultLogoUrl = LogoTransformerFactory.this.lookAndFeelProperties.getDefaultCssLogoUrl()) != null && !defaultLogoUrl.startsWith("http://") && !defaultLogoUrl.startsWith(".")) {
                    defaultLogoUrl = prefix + defaultLogoUrl;
                }
                replacedContent = replacedContent.replace("@defaultLogoUrl", defaultLogoUrl);
                replacedContent = replacedContent.replace("@maxLogoHeight", String.valueOf(LogoTransformerFactory.this.lookAndFeelProperties.getMaxLogoHeight()));
                return replacedContent;
            }
        };
    }
}

