/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel.filter;

import com.atlassian.plugin.servlet.ResourceDownloadUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ImageDownloader {
    private final int BUFSIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDownload(HttpServletRequest req, HttpServletResponse resp, ServletContext context, String filename, boolean shouldClose) throws IOException {
        ServletOutputStream op = null;
        FilterInputStream in = null;
        try {
            File f = new File(filename);
            String mimeType = filename.endsWith(".ico") ? "image/x-icon" : context.getMimeType(filename);
            if (mimeType == null) {
                context.log("Could not get MIME type of " + filename);
                resp.setStatus(500);
                return;
            }
            resp.setContentType(mimeType);
            resp.setContentLength((int)f.length());
            if (req.getServletPath().startsWith("/s")) {
                ResourceDownloadUtils.addPublicCachingHeaders((HttpServletRequest)req, (HttpServletResponse)resp);
            }
            op = resp.getOutputStream();
            in = new DataInputStream(new FileInputStream(f));
            byte[] bbuf = new byte[1024];
            int length = 0;
            while (in != null && (length = ((DataInputStream)in).read(bbuf)) != -1) {
                op.write(bbuf, 0, length);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (op != null) {
                op.flush();
                if (shouldClose) {
                    op.close();
                }
            }
        }
    }
}

