/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel.filter;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.lookandfeel.LogoChoice;
import com.atlassian.jira.lookandfeel.LookAndFeelProperties;
import com.atlassian.jira.lookandfeel.filter.ImageDownloader;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FaviconInterceptor
implements Filter {
    private FilterConfig config;
    private LookAndFeelProperties properties;
    private final JiraHome jiraHome;
    private final PluginSettings globalSettings;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private static final String JIRA_FAVICON_HIRES = "jira-favicon-hires.png";
    private static final String JIRA_FAVICON = "jira-favicon-scaled.png";
    private static final String JIRA_FAVICON_IE = "jira-favicon-scaled.ico";

    public FaviconInterceptor(LookAndFeelProperties properties, JiraHome jiraHome, PluginSettingsFactory pluginSettingsFactory, WebResourceUrlProvider webResourceUrlProvider) {
        this.properties = properties;
        this.jiraHome = jiraHome;
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletResponse res = (HttpServletResponse)response;
            HttpServletRequest req = (HttpServletRequest)request;
            String requestURL = req.getRequestURL().toString();
            if (requestURL.contains("/attachment/")) {
                chain.doFilter(request, response);
                return;
            }
            if (requestURL.contains("favicon")) {
                if (this.properties.getFaviconChoice().equals((Object)LogoChoice.JIRA)) {
                    if ("true".equals(this.globalSettings.get("com.atlassian.jira.lookandfeel:isDefaultFavicon"))) {
                        String faviconUrl = (String)this.globalSettings.get("com.atlassian.jira.lookandfeel:customDefaultFaviconURL");
                        if (!faviconUrl.startsWith("http") && !faviconUrl.startsWith(".")) {
                            faviconUrl = this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.AUTO) + faviconUrl;
                        }
                        res.sendRedirect(faviconUrl);
                    } else {
                        chain.doFilter(request, response);
                    }
                    return;
                }
                ImageDownloader downloader = new ImageDownloader();
                if (requestURL.contains(".ico")) {
                    downloader.doDownload(req, res, this.config.getServletContext(), this.jiraHome.getHomePath() + "/logos/" + JIRA_FAVICON_IE, true);
                } else if (requestURL.contains("hires")) {
                    downloader.doDownload(req, res, this.config.getServletContext(), this.jiraHome.getHomePath() + "/logos/" + JIRA_FAVICON_HIRES, true);
                } else {
                    downloader.doDownload(req, res, this.config.getServletContext(), this.jiraHome.getHomePath() + "/logos/" + JIRA_FAVICON, true);
                }
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private void addCacheHeaders(HttpServletResponse res) {
    }

    public void destroy() {
    }
}

