/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.lookandfeel.UrlAutocomplete;
import com.atlassian.jira.util.I18nHelper;

public class LookAndFeelUrlAutocomplete
implements UrlAutocomplete {
    private I18nHelper i18nHelper;

    public LookAndFeelUrlAutocomplete(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    @Override
    public String completeUrl(String url) {
        if (url != null && url.startsWith("/")) {
            url = ComponentAccessor.getApplicationProperties().getString("jira.baseurl") + url;
        }
        return url;
    }

    @Override
    public String completionTip(String url) {
        if (url == null || !url.startsWith("http://") && !url.startsWith("https://")) {
            return this.i18nHelper.getText("jira.lookandfeel.upload.url.invalid.http");
        }
        return this.i18nHelper.getText("jira.lookandfeel.upload.url.invalid.noclue");
    }
}

