/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.lookandfeel.LogoChoice;
import com.atlassian.jira.lookandfeel.LookAndFeelConstants;
import com.atlassian.jira.lookandfeel.LookAndFeelProperties;
import com.atlassian.jira.lookandfeel.upload.UploadService;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.BooleanUtils;

public class LookAndFeelPropertiesImpl
implements LookAndFeelProperties {
    private static final String CUSTOMIZE_COLORS = "com.atlassian.jira.lookandfeel.customizeColors";
    private static final String LOGO_CHOICE = "com.atlassian.jira.lookandfeel.logoChoice";
    private static final String FAVICON_CHOICE = "com.atlassian.jira.lookandfeel.faviconChoice";
    private static final String DEFAULT_LOGO_URL = "com.atlassian.jira.lookandfeel.logo.default.url";
    private static final String DEFAULT_FAVICON_URL = "com.atlassian.jira.lookandfeel.favicon.default.url";
    private static final boolean DEFAULT_WHITE_ARROW = false;
    private final PluginSettings globalSettings;
    private final LookAndFeelBean lookAndFeelBean;
    private final UploadService uploadService;
    private final ApplicationProperties applicationProperties;

    public LookAndFeelPropertiesImpl(PluginSettingsFactory pluginSettingsFactory, ApplicationProperties applicationProperties, UploadService uploadService) {
        this.applicationProperties = applicationProperties;
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
        this.lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)applicationProperties);
        this.uploadService = uploadService;
    }

    @Override
    public void setCustomizeColors(boolean value) {
        this.globalSettings.put(CUSTOMIZE_COLORS, (Object)String.valueOf(value));
    }

    @Override
    public boolean getCustomizeColors() {
        String customizeColors = (String)this.globalSettings.get(CUSTOMIZE_COLORS);
        if (customizeColors != null) {
            return Boolean.parseBoolean(customizeColors);
        }
        return false;
    }

    @Override
    public void setLogoChoice(LogoChoice choice) {
        Assertions.notNull((String)"Choice cannot be null", (Object)((Object)choice));
        this.globalSettings.put(LOGO_CHOICE, (Object)choice.toString());
    }

    @Override
    public LogoChoice getLogoChoice() {
        LogoChoice logoOptionChoice = null;
        String logoChoice = (String)this.globalSettings.get(LOGO_CHOICE);
        if (logoChoice != null) {
            logoOptionChoice = LogoChoice.safeValueOf(logoChoice);
        }
        return logoOptionChoice != null ? logoOptionChoice : LogoChoice.JIRA;
    }

    @Override
    public void setFaviconChoice(LogoChoice choice) {
        Assertions.notNull((String)"Choice cannot be null", (Object)((Object)choice));
        this.globalSettings.put(FAVICON_CHOICE, (Object)choice.toString());
    }

    @Override
    public LogoChoice getFaviconChoice() {
        LogoChoice faviconOptionChoice = null;
        String faviconChoice = (String)this.globalSettings.get(FAVICON_CHOICE);
        if (faviconChoice != null) {
            faviconOptionChoice = LogoChoice.safeValueOf(faviconChoice);
        }
        return faviconOptionChoice != null ? faviconOptionChoice : LogoChoice.JIRA;
    }

    @Override
    public void reset() {
        this.setCustomizeColors(false);
        this.setLogoChoice(LogoChoice.JIRA);
        this.setFaviconChoice(LogoChoice.JIRA);
        this.resetDefaultFaviconUrl();
        this.resetDefaultLogoUrl();
        this.resetApplicationTitleShownOnLogo();
    }

    private void resetApplicationTitleShownOnLogo() {
        this.applicationProperties.setOption("jira.lf.logo.show.application.title", false);
    }

    @Override
    public void uploadDefaultLogo(BufferedImage image) {
        Assertions.notNull((String)"image cannot be null", (Object)image);
        Map<String, String> imageInfo = this.uploadService.uploadDefaultLogo(image);
        if (imageInfo != null) {
            this.setLogoDefaults(imageInfo.get("path"), imageInfo.get("width"), imageInfo.get("height"));
        }
    }

    @Override
    public void setDefaultLogo(String url, String width, String height) {
        Assertions.notNull((String)"URL cannot be null", (Object)url);
        this.globalSettings.put("com.atlassian.jira.lookandfeel:isDefaultLogo", (Object)BooleanUtils.toStringTrueFalse((boolean)true));
        this.setLogoDefaults(url, width, height);
    }

    @Override
    public void resetDefaultLogo() {
        this.globalSettings.put("com.atlassian.jira.lookandfeel:isDefaultLogo", (Object)BooleanUtils.toStringTrueFalse((boolean)false));
        this.deleteUploadedCustomDefaultLogo();
        this.setLogoDefaults(this.applicationProperties.getDefaultString("jira.lf.logo.url"), this.applicationProperties.getDefaultString("jira.lf.logo.width"), this.applicationProperties.getDefaultString("jira.lf.logo.height"));
    }

    private void deleteUploadedCustomDefaultLogo() {
        File file = new File(this.uploadService.getLogoDirectory(), "jira-logo-default-scaled.png");
        FileUtils.deleteQuietly((File)file);
    }

    @Override
    public void uploadDefaultFavicon(BufferedImage image) {
        Assertions.notNull((String)"image cannot be null", (Object)image);
        Map<String, String> imageInfo = this.uploadService.uploadDefaultFavicon(image);
        if (imageInfo != null) {
            this.setFaviconDefaults(imageInfo.get("path"), imageInfo.get("path"), imageInfo.get("width"), imageInfo.get("height"));
        }
    }

    @Override
    public void setDefaultFavicon(String url, String width, String height) {
        Assertions.notNull((String)"url cannot be null", (Object)url);
        this.globalSettings.put("com.atlassian.jira.lookandfeel:isDefaultFavicon", (Object)BooleanUtils.toStringTrueFalse((boolean)true));
        this.setFaviconDefaults(url, url, width, height);
    }

    @Override
    public void setDefaultFavicon(String url, String hiresUrl, String width, String height) {
        Assertions.notNull((String)"url cannot be null", (Object)url);
        Assertions.notNull((String)"hiresUrl cannot be null", (Object)hiresUrl);
        this.globalSettings.put("com.atlassian.jira.lookandfeel:isDefaultFavicon", (Object)BooleanUtils.toStringTrueFalse((boolean)true));
        this.setFaviconDefaults(url, hiresUrl, width, height);
    }

    @Override
    public void resetDefaultFavicon() {
        this.globalSettings.put("com.atlassian.jira.lookandfeel:isDefaultFavicon", (Object)BooleanUtils.toStringTrueFalse((boolean)false));
        this.deleteUploadedCustomDefaultFavicon();
        this.setFaviconDefaults("/favicon.ico", "/images/64jira.png", LookAndFeelConstants.BUILTIN_DEFAULT_FAVICON_WIDTH, LookAndFeelConstants.BUILTIN_DEFAULT_FAVICON_HEIGHT);
    }

    private void deleteUploadedCustomDefaultFavicon() {
        File file = new File(this.uploadService.getLogoDirectory(), "jira-favicon-default-scaled.png");
        FileUtils.deleteQuietly((File)file);
    }

    @Override
    public boolean isUsingCustomDefaultLogo() {
        return "true".equals(this.globalSettings.get("com.atlassian.jira.lookandfeel:isDefaultLogo"));
    }

    @Override
    public boolean isUsingCustomDefaultFavicon() {
        return "true".equals(this.globalSettings.get("com.atlassian.jira.lookandfeel:isDefaultFavicon"));
    }

    @Override
    public String getDefaultCssLogoUrl() {
        if (this.isUsingCustomDefaultLogo()) {
            return (String)this.globalSettings.get("com.atlassian.jira.lookandfeel:DefaultlogoURL");
        }
        return "/download/resources/com.atlassian.jira.lookandfeel:edit-look-and-feel/images/charlie48.png";
    }

    @Override
    public String getDefaultLogoUrl() {
        if (this.isUsingCustomDefaultLogo()) {
            return (String)this.globalSettings.get("com.atlassian.jira.lookandfeel:DefaultlogoURL");
        }
        return "/images/icon-jira-logo.png";
    }

    @Override
    public String getDefaultFaviconUrl() {
        if (this.isUsingCustomDefaultFavicon()) {
            return (String)this.globalSettings.get("com.atlassian.jira.lookandfeel:customDefaultFaviconURL");
        }
        return "/favicon.ico";
    }

    @Override
    public String getDefaultFaviconHiresUrl() {
        if (this.isUsingCustomDefaultFavicon()) {
            String hires = (String)this.globalSettings.get("com.atlassian.jira.lookandfeel:customDefaultFaviconHiresURL");
            return hires != null ? hires : (String)this.globalSettings.get("com.atlassian.jira.lookandfeel:customDefaultFaviconURL");
        }
        return "/images/64jira.png";
    }

    private void setFaviconDefaults(String path, String hiresPath, String width, String height) {
        if (this.getLogoChoice() == LogoChoice.JIRA) {
            this.globalSettings.put("com.atlassian.jira.lookandfeel:usingCustomFavicon", (Object)BooleanUtils.toStringTrueFalse((boolean)false));
        }
        this.globalSettings.put("com.atlassian.jira.lookandfeel:customDefaultFaviconURL", (Object)path);
        this.globalSettings.put("com.atlassian.jira.lookandfeel:customDefaultFaviconHiresURL", (Object)hiresPath);
        this.globalSettings.put("com.atlassian.jira.lookandfeel:faviconWidth", (Object)width);
        this.globalSettings.put("com.atlassian.jira.lookandfeel:faviconHeight", (Object)height);
        if (!"true".equals(this.globalSettings.get("com.atlassian.jira.lookandfeel:usingCustomFavicon"))) {
            this.lookAndFeelBean.setFaviconUrl(path);
            this.lookAndFeelBean.setFaviconHiResUrl(hiresPath);
        }
    }

    private void setLogoDefaults(String path, String width, String height) {
        if (this.getLogoChoice() == LogoChoice.JIRA) {
            this.globalSettings.put("com.atlassian.jira.lookandfeel:usingCustomLogo", (Object)BooleanUtils.toStringTrueFalse((boolean)false));
        }
        this.globalSettings.put("com.atlassian.jira.lookandfeel:DefaultlogoURL", (Object)path);
        this.globalSettings.put("com.atlassian.jira.lookandfeel:logoWidth", (Object)width);
        this.globalSettings.put("com.atlassian.jira.lookandfeel:logoHeight", (Object)height);
        if (!"true".equals(this.globalSettings.get("com.atlassian.jira.lookandfeel:usingCustomLogo"))) {
            this.lookAndFeelBean.setLogoUrl(path);
            this.lookAndFeelBean.setLogoHeight(height);
            this.lookAndFeelBean.setLogoWidth(width);
        }
    }

    @Override
    public void setBlackArrow(boolean blackArrow) {
        this.globalSettings.put("com.atlassian.jira.lookandfeel:usingBlackArrow", (Object)String.valueOf(blackArrow));
    }

    @Override
    public boolean isBlackArrow() {
        Object shouldUseBlackArrowAsObject = this.globalSettings.get("com.atlassian.jira.lookandfeel:usingBlackArrow");
        if (shouldUseBlackArrowAsObject == null) {
            return false;
        }
        return Boolean.parseBoolean(shouldUseBlackArrowAsObject.toString());
    }

    @Override
    public void resetDefaultFaviconUrl() {
        if (!"true".equals(this.globalSettings.get("com.atlassian.jira.lookandfeel:isDefaultFavicon"))) {
            this.globalSettings.remove(DEFAULT_FAVICON_URL);
        } else {
            this.globalSettings.put(DEFAULT_FAVICON_URL, (Object)"com.atlassian.jira.lookandfeel:customDefaultFaviconURL");
        }
    }

    @Override
    public void resetDefaultLogoUrl() {
        if (!"true".equals(this.globalSettings.get("com.atlassian.jira.lookandfeel:isDefaultLogo"))) {
            this.globalSettings.remove(DEFAULT_LOGO_URL);
        } else {
            this.globalSettings.put(DEFAULT_LOGO_URL, (Object)"com.atlassian.jira.lookandfeel:DefaultlogoURL");
        }
    }

    @Override
    public boolean isApplicationTitleShownOnLogo() {
        return this.applicationProperties.getOption("jira.lf.logo.show.application.title");
    }

    @Override
    public void setApplicationTitleShownOnLogoTo(boolean shouldShow) {
        this.applicationProperties.setOption("jira.lf.logo.show.application.title", shouldShow);
    }

    @Override
    public int getMaxLogoHeight() {
        return 30;
    }
}

