/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel;

import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.core.util.thumbnail.ThumbnailDimension;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImageScaler {
    private final Thumber thumber = new Thumber(Thumbnail.MimeType.PNG);

    public BufferedImage scaleImageToMaxHeight(BufferedImage image, int maxHeight) {
        int imageHeight = image.getHeight(null);
        if (imageHeight <= maxHeight) {
            return image;
        }
        int imageWidth = image.getWidth(null);
        double ratio = (double)imageHeight / (double)maxHeight;
        int maxWidth = (int)((double)imageWidth / ratio);
        ThumbnailDimension dimensionHelper = this.thumber.determineScaleSize(maxWidth, maxHeight, imageWidth, imageHeight);
        return this.thumber.scaleImage((Image)image, dimensionHelper);
    }

    public BufferedImage scaleImageToMaxWidth(BufferedImage image, int maxWidth) {
        int imageWidth = image.getWidth(null);
        if (imageWidth <= maxWidth) {
            return image;
        }
        int imageHeight = image.getHeight(null);
        double ratio = (double)imageWidth / (double)maxWidth;
        int maxHeight = (int)((double)imageHeight / ratio);
        ThumbnailDimension dimensionHelper = this.thumber.determineScaleSize(maxWidth, maxHeight, imageWidth, imageHeight);
        return this.thumber.scaleImage((Image)image, dimensionHelper);
    }

    public BufferedImage scaleImageToSquare(BufferedImage image, int maxSize, boolean crop) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        if (imageWidth <= maxSize && imageHeight <= maxSize) {
            return image;
        }
        BufferedImage scaledImage = image;
        if (crop && imageWidth != imageHeight) {
            scaledImage = this.cropImage(image);
        }
        ThumbnailDimension dimensionHelper = this.thumber.determineScaleSize(maxSize, maxSize, scaledImage.getWidth(null), scaledImage.getHeight(null));
        return this.thumber.scaleImage((Image)scaledImage, dimensionHelper);
    }

    private BufferedImage cropImage(BufferedImage image) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        int largestSquareWidth = Math.min(imageWidth, imageHeight);
        int xOffset = (imageWidth - largestSquareWidth) / 2;
        int yOffset = (imageHeight - largestSquareWidth) / 2;
        return image.getSubimage(xOffset, yOffset, largestSquareWidth, largestSquareWidth);
    }
}

