/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel;

import java.awt.Color;

public class HSBColor {
    private final int hue;
    private final int saturation;
    private final int brightness;
    private final Color color;
    private final String hexString;

    public HSBColor(Color color) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.hue = Math.round(hsb[0] * 359.0f);
        this.saturation = Math.round(hsb[1] * 100.0f);
        this.brightness = Math.round(hsb[2] * 100.0f);
        this.color = color;
        this.hexString = HSBColor.getHexFromColor(color);
    }

    public HSBColor(String hexString) {
        this(Color.decode(hexString.startsWith("#") ? hexString : "#" + hexString));
    }

    public HSBColor(int hue, int saturation, int brightness) {
        this(new Color(Color.HSBtoRGB((float)hue / 359.0f, (float)saturation / 100.0f, (float)brightness / 100.0f)));
    }

    public int getHue() {
        return this.hue;
    }

    public int getSaturation() {
        return this.saturation;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public Color getColor() {
        return this.color;
    }

    public String getHexString() {
        return this.hexString;
    }

    public float getPerceivedBrightness() {
        return (float)(this.color.getRed() * 299 + this.color.getGreen() * 587 + this.color.getBlue() * 114) / 1000.0f;
    }

    public boolean hasTransparency() {
        return this.color.getAlpha() < 255;
    }

    public HSBColor lightenByPercentage(float percentage) {
        return this.lightenByAmount(Math.round((float)this.brightness * percentage / 100.0f));
    }

    public HSBColor lightenByAmount(int amount) {
        return new HSBColor(this.hue, this.saturation, Math.min(100, this.brightness + amount));
    }

    public HSBColor darkenByPercentage(float percentage) {
        return this.darkenByAmount(Math.round((float)this.brightness * percentage / 100.0f));
    }

    public HSBColor darkenByAmount(int amount) {
        return new HSBColor(this.hue, this.saturation, Math.max(0, this.brightness - amount));
    }

    public HSBColor saturateByPercentage(float percentage) {
        return this.saturateByAmount(Math.round((float)this.saturation * percentage / 100.0f));
    }

    public HSBColor saturateByAmount(int amount) {
        return new HSBColor(this.hue, Math.min(100, this.saturation + amount), this.brightness);
    }

    public HSBColor desaturateByPercentage(float percentage) {
        return this.desaturateByAmount(Math.round((float)this.saturation * percentage / 100.0f));
    }

    public HSBColor desaturateByAmount(int amount) {
        return new HSBColor(this.hue, Math.max(0, this.saturation - amount), this.brightness);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HSBColor hsbColor = (HSBColor)o;
        if (this.brightness != hsbColor.brightness) {
            return false;
        }
        if (this.hue != hsbColor.hue) {
            return false;
        }
        if (this.saturation != hsbColor.saturation) {
            return false;
        }
        return this.color.getTransparency() == hsbColor.color.getTransparency();
    }

    public int hashCode() {
        int result = this.hue;
        result = 31 * result + this.saturation;
        result = 31 * result + this.brightness;
        result = 31 * result + this.color.getTransparency();
        return result;
    }

    public String toString() {
        return "HSBColor[h=" + this.hue + ",s=" + this.saturation + ",b=" + this.brightness + ",a=" + this.color.getTransparency() + ",hex=" + this.getHexString() + "]";
    }

    private static String getHexFromColor(Color color) {
        String result = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        while (result.length() < 6) {
            result = "0" + result;
        }
        return "#" + result;
    }
}

