/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.admin.IntroductionProperty;
import com.atlassian.jira.avatar.GravatarSettings;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.event.web.action.admin.LookAndFeelUpdatedEvent;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.lookandfeel.AutoLookAndFeelManager;
import com.atlassian.jira.lookandfeel.LogoChoice;
import com.atlassian.jira.lookandfeel.LookAndFeelProperties;
import com.atlassian.jira.lookandfeel.UrlAutocomplete;
import com.atlassian.jira.lookandfeel.image.ImageDescriptor;
import com.atlassian.jira.lookandfeel.image.ImageDescriptorFactory;
import com.atlassian.jira.lookandfeel.upload.UploadService;
import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.plugin.userformat.configuration.UserFormatTypeConfiguration;
import com.atlassian.jira.plugin.userformat.descriptors.UserFormatModuleDescriptors;
import com.atlassian.jira.plugin.userformat.descriptors.UserFormatTypes;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.setting.GzipCompression;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.jira.web.action.admin.ViewApplicationProperties;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;
import webwork.multipart.MultiPartRequestWrapper;

@WebSudoRequired
public class EditLookAndFeel
extends ViewApplicationProperties {
    private static final Logger log = LoggerFactory.getLogger(EditLookAndFeel.class);
    public static final String USER_FORMAT_PREFIX = "user_format_for_";
    private final LookAndFeelProperties lookAndFeelProperties;
    private final VelocityRequestContextFactory requestContextFactory;
    private final FeatureManager featureManager;
    private final I18nHelper i18nHelper;
    private final UploadService uploadService;
    private final PluginSettings globalSettings;
    private final EventPublisher eventPublisher;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final AutoLookAndFeelManager autoLookAndFeelManager;
    private final ImageDescriptorFactory imageDescriptorFactory;
    private final UrlAutocomplete urlAutocomplete;
    private final UserFormatTypes userFormatTypes;
    private final UserFormatModuleDescriptors userFormatModuleDescriptors;
    private final UserFormatTypeConfiguration userFormatTypeConfiguration;
    private final Supplier<LookAndFeelBean> lookAndFeelBean;
    private String logoUrl;
    private String faviconUrl;
    private boolean showSiteTitleOnLogo;

    public EditLookAndFeel(UserSearchService searchService, I18nHelper.BeanFactory i18nBeanFactory, LocaleManager localeManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, TimeZoneService timeZoneService, RendererManager rendererManager, LookAndFeelProperties lookAndFeelProperties, PluginSettingsFactory pluginSettingsFactory, VelocityRequestContextFactory requestContextFactory, UploadService uploadService, FeatureManager featureManager, PluginAccessor pluginAccessor, IntroductionProperty introduction, EventPublisher eventPublisher, SoyTemplateRenderer soyTemplateRenderer, WebResourceUrlProvider webResourceUrlProvider, AutoLookAndFeelManager autoLookAndFeelManager, JiraLicenseService jiraLicenseService, GravatarSettings gravatarSettings, ImageDescriptorFactory imageDescriptorFactory, UrlAutocomplete urlAutocomplete) {
        super(searchService, localeManager, timeZoneService, rendererManager, pluginAccessor, (GzipCompression)ComponentAccessor.getComponent(GzipCompression.class), featureManager, introduction, jiraLicenseService, gravatarSettings);
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.eventPublisher = eventPublisher;
        this.uploadService = uploadService;
        this.requestContextFactory = requestContextFactory;
        this.lookAndFeelProperties = lookAndFeelProperties;
        this.featureManager = featureManager;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.autoLookAndFeelManager = autoLookAndFeelManager;
        this.imageDescriptorFactory = imageDescriptorFactory;
        this.urlAutocomplete = urlAutocomplete;
        this.showSiteTitleOnLogo = false;
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
        this.i18nHelper = i18nBeanFactory.getInstance(authenticationContext.getLoggedInUser());
        this.userFormatTypes = (UserFormatTypes)ComponentAccessor.getComponent(UserFormatTypes.class);
        this.userFormatModuleDescriptors = (UserFormatModuleDescriptors)ComponentAccessor.getComponent(UserFormatModuleDescriptors.class);
        this.userFormatTypeConfiguration = (UserFormatTypeConfiguration)ComponentAccessor.getComponent(UserFormatTypeConfiguration.class);
        this.lookAndFeelBean = Suppliers.memoize(() -> LookAndFeelBean.getInstance((ApplicationProperties)applicationProperties));
    }

    public String getLogoFormAsHtml() {
        HashMap<String, String> soyRenderData = new HashMap<String, String>();
        soyRenderData.put("uploadAction", "LookAndFeel!uploadLogo.jspa");
        soyRenderData.put("resetAction", "LookAndFeel!resetLogo.jspa?atl_token=" + this.getXsrfToken());
        soyRenderData.put("imageWithContext", this.addContextToUrl(((LookAndFeelBean)this.lookAndFeelBean.get()).getLogoUrl()));
        soyRenderData.put("imageType", "logo");
        soyRenderData.put("imageDescription", this.i18nHelper.getText("admin.globalsettings.lookandfeel.edit.look.and.feel.recommended.logo.dimensions"));
        soyRenderData.put("formTitle", this.getText("admin.globalsettings.lookandfeel.logo"));
        if (this.globalSettings.get("com.atlassian.jira.lookandfeel:usingCustomLogo") == null) {
            this.globalSettings.put("com.atlassian.jira.lookandfeel:usingCustomLogo", (Object)Boolean.toString(false));
        }
        soyRenderData.put("isNotDefault", this.globalSettings.get("com.atlassian.jira.lookandfeel:usingCustomLogo").toString());
        soyRenderData.put("token", this.getXsrfToken());
        try {
            return this.soyTemplateRenderer.render("com.atlassian.jira.lookandfeel:logoFormSoy", "JIRA.Templates.LookandFeelLogo.logoForm", soyRenderData);
        }
        catch (SoyException e) {
            log.warn("Could not render soy template for logo form");
            log.debug("Exception: ", (Throwable)e);
            return null;
        }
    }

    public String getSiteTitleFormAsHtml() {
        HashMap<String, String> soyRenderData = new HashMap<String, String>();
        soyRenderData.put("action", "LookAndFeel!updateSiteTitle.jspa");
        soyRenderData.put("token", this.getXsrfToken());
        if (this.lookAndFeelProperties.isApplicationTitleShownOnLogo()) {
            soyRenderData.put("isChecked", Boolean.toString(this.lookAndFeelProperties.isApplicationTitleShownOnLogo()));
        }
        try {
            return this.soyTemplateRenderer.render("com.atlassian.jira.lookandfeel:logoFormSoy", "JIRA.Templates.LookandFeelLogo.showSiteTitleForm", soyRenderData);
        }
        catch (SoyException e) {
            log.warn("Could not render soy template for site title form");
            log.debug("Exception: ", (Throwable)e);
            return null;
        }
    }

    public String getFavIconFormAsHtml() {
        HashMap<String, String> soyRenderData = new HashMap<String, String>();
        soyRenderData.put("uploadAction", "LookAndFeel!uploadFavicon.jspa");
        soyRenderData.put("resetAction", "LookAndFeel!resetFavicon.jspa?atl_token=" + this.getXsrfToken());
        soyRenderData.put("imageWithContext", this.addContextToUrl(((LookAndFeelBean)this.lookAndFeelBean.get()).getFaviconHiResUrl()));
        soyRenderData.put("imageType", "favicon");
        soyRenderData.put("formTitle", this.getText("admin.globalsettings.lookandfeel.favicon"));
        if (this.globalSettings.get("com.atlassian.jira.lookandfeel:usingCustomFavicon") == null) {
            this.globalSettings.put("com.atlassian.jira.lookandfeel:usingCustomFavicon", (Object)Boolean.toString(false));
        }
        soyRenderData.put("isNotDefault", this.globalSettings.get("com.atlassian.jira.lookandfeel:usingCustomFavicon").toString());
        soyRenderData.put("token", this.getXsrfToken());
        try {
            return this.soyTemplateRenderer.render("com.atlassian.jira.lookandfeel:logoFormSoy", "JIRA.Templates.LookandFeelLogo.logoForm", soyRenderData);
        }
        catch (SoyException e) {
            log.warn("Could not render soy template for fav icon form");
            log.debug("Exception: ", (Throwable)e);
            return null;
        }
    }

    public String getUserFormatFormAsHtml() {
        HashMap<String, Object> soyRenderData = new HashMap<String, Object>();
        soyRenderData.put("submitAction", "LookAndFeel!userFormatUpdate.jspa");
        soyRenderData.put("formTitle", this.getText("admin.globalsettings.lookandfeel.user.formats"));
        soyRenderData.put("token", this.getXsrfToken());
        ArrayList userFormatTypes = new ArrayList();
        for (String formatType : this.getUserFormatTypes()) {
            Collection<UserFormatModuleDescriptor> userFormatModuleDescriptorsForType = this.getUserFormatModuleDescriptorsForType(formatType);
            if (userFormatModuleDescriptorsForType.size() > 1) {
                HashMap<String, Object> formatTypeData = new HashMap<String, Object>();
                formatTypeData.put("label", this.getUserFormatTypeName(formatType));
                formatTypeData.put("name", USER_FORMAT_PREFIX + formatType);
                ArrayList options = new ArrayList(userFormatModuleDescriptorsForType.size());
                for (UserFormatModuleDescriptor ufmd : userFormatModuleDescriptorsForType) {
                    HashMap<String, String> option = new HashMap<String, String>();
                    option.put("text", ufmd.getName());
                    option.put("value", ufmd.getCompleteKey());
                    if (this.getUserFormatKey(formatType).equalsIgnoreCase(ufmd.getCompleteKey())) {
                        option.put("selected", "true");
                    }
                    options.add(option);
                }
                formatTypeData.put("options", options);
                userFormatTypes.add(formatTypeData);
            }
            soyRenderData.put("userTypes", userFormatTypes);
        }
        try {
            return this.soyTemplateRenderer.render("com.atlassian.jira.lookandfeel:userFormatFormSoy", "JIRA.Templates.LookandFeelUserFormat.userformatForm", soyRenderData);
        }
        catch (SoyException e) {
            log.warn("Could not render soy template for user format types");
            log.debug("Exception: ", (Throwable)e);
            return null;
        }
    }

    private String addContextToUrl(String url) {
        if (url != null && !url.startsWith("http://") && !url.startsWith("https://")) {
            url = this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.AUTO) + url;
        }
        return url;
    }

    public boolean currentSiteTitleOnLogoSetting() {
        return this.lookAndFeelProperties.isApplicationTitleShownOnLogo();
    }

    public boolean isShowSiteTitleOnLogo() {
        return this.showSiteTitleOnLogo;
    }

    public void setShowSiteTitleOnLogo(boolean showSiteTitleOnLogo) {
        this.showSiteTitleOnLogo = showSiteTitleOnLogo;
    }

    private void setDefaultFavicon(LookAndFeelBean lookAndFeelBean) {
        lookAndFeelBean.setFaviconUrl(this.lookAndFeelProperties.getDefaultFaviconUrl());
        lookAndFeelBean.setFaviconHiResUrl(this.lookAndFeelProperties.getDefaultFaviconHiresUrl());
        this.lookAndFeelProperties.resetDefaultFaviconUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresXsrfCheck
    public String doUploadLogo() {
        ImageDescriptor imageDescriptor;
        block12: {
            String parameterName = "logoFile";
            String serverPath = ServletContextProvider.getServletContext().getRealPath("/");
            MultiPartRequestWrapper multiPartRequest = ServletActionContext.getMultiPartRequest();
            if (multiPartRequest == null) {
                return "error";
            }
            imageDescriptor = null;
            try {
                if (StringUtils.isNotBlank((String)multiPartRequest.getFilesystemName("logoFile"))) {
                    imageDescriptor = this.imageDescriptorFactory.withRequest("logoFile", multiPartRequest);
                    break block12;
                }
                String url = this.urlAutocomplete.completeUrl(this.getLogoUrl());
                if (this.imageDescriptorFactory.isUrlSupported(url)) {
                    imageDescriptor = this.imageDescriptorFactory.withUrl(url);
                    break block12;
                }
                this.addErrorMessage(this.getText("jira.lookandfeel.upload.url.invalid") + " " + this.urlAutocomplete.completionTip(url));
                return "error";
            }
            catch (IOException e) {
                this.addErrorMessage(this.getText("jira.lookandfeel.upload.error", "", e.getMessage()));
                return "error";
            }
        }
        try {
            String string;
            if (imageDescriptor != null) {
                this.addErrorMessages(this.uploadService.uploadLogo(imageDescriptor, (LookAndFeelBean)this.lookAndFeelBean.get()));
                if (this.hasAnyErrors()) {
                    string = "error";
                    return string;
                }
            }
            this.setLogoUrl(((LookAndFeelBean)this.lookAndFeelBean.get()).getLogoUrl());
            this.autoLookAndFeelManager.backupColorScheme();
            this.autoLookAndFeelManager.generateFromLogo(this.getLoggedInUser());
            this.eventPublisher.publish((Object)new LookAndFeelUpdatedEvent(this.getLoggedInUser(), LookAndFeelUpdatedEvent.Type.UPLOAD_LOGO));
            string = this.getRedirect("LookAndFeel!default.jspa");
            return string;
        }
        finally {
            if (imageDescriptor != null) {
                imageDescriptor.closeImageStreamQuietly();
            }
        }
    }

    @RequiresXsrfCheck
    public String doAutoUpdateColors() {
        this.autoLookAndFeelManager.backupColorScheme();
        this.autoLookAndFeelManager.generateFromLogo(this.getLoggedInUser());
        this.eventPublisher.publish((Object)new LookAndFeelUpdatedEvent(this.getLoggedInUser(), LookAndFeelUpdatedEvent.Type.AUTO_COLOR_SCHEME));
        return this.getRedirect("LookAndFeel!default.jspa");
    }

    @RequiresXsrfCheck
    public String doRestoreColorScheme() {
        this.autoLookAndFeelManager.restoreBackupColorScheme();
        this.eventPublisher.publish((Object)new LookAndFeelUpdatedEvent(this.getLoggedInUser(), LookAndFeelUpdatedEvent.Type.UNDO_AUTO_COLOR_SCHEME));
        this.refreshResources();
        return this.getRedirect("LookAndFeel!default.jspa");
    }

    @RequiresXsrfCheck
    public String doUpdateSiteTitle() {
        this.lookAndFeelProperties.setApplicationTitleShownOnLogoTo(this.showSiteTitleOnLogo);
        this.eventPublisher.publish((Object)new LookAndFeelUpdatedEvent(this.getLoggedInUser(), LookAndFeelUpdatedEvent.Type.SITE_TITLE));
        return this.getRedirect("LookAndFeel!default.jspa");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresXsrfCheck
    public String doUploadFavicon() {
        ImageDescriptor imageDescriptor;
        block10: {
            String parameterName = "faviconFile";
            String serverPath = ServletContextProvider.getServletContext().getRealPath("/");
            MultiPartRequestWrapper multiPartRequest = ServletActionContext.getMultiPartRequest();
            if (multiPartRequest == null) {
                return "error";
            }
            imageDescriptor = null;
            try {
                if (StringUtils.isNotBlank((String)multiPartRequest.getFilesystemName("faviconFile"))) {
                    imageDescriptor = this.imageDescriptorFactory.withRequest("faviconFile", multiPartRequest);
                    break block10;
                }
                String url = this.urlAutocomplete.completeUrl(this.getFaviconUrl());
                if (this.imageDescriptorFactory.isUrlSupported(url)) {
                    imageDescriptor = this.imageDescriptorFactory.withUrl(url);
                    break block10;
                }
                this.addErrorMessage(this.getText("jira.lookandfeel.upload.url.invalid") + " " + this.urlAutocomplete.completionTip(url));
                return "error";
            }
            catch (IOException e) {
                this.addErrorMessage(this.getText("jira.lookandfeel.upload.error", "", e.getMessage()));
                return "error";
            }
        }
        try {
            if (imageDescriptor != null) {
                this.addErrorMessages(this.uploadService.uploadFavicon((LookAndFeelBean)this.lookAndFeelBean.get(), imageDescriptor));
                this.lookAndFeelProperties.setFaviconChoice(LogoChoice.UPLOAD);
            }
        }
        finally {
            if (imageDescriptor != null) {
                imageDescriptor.closeImageStreamQuietly();
            }
        }
        this.eventPublisher.publish((Object)new LookAndFeelUpdatedEvent(this.getLoggedInUser(), LookAndFeelUpdatedEvent.Type.UPLOAD_FAVICON));
        return this.getRedirect("LookAndFeel!default.jspa");
    }

    @RequiresXsrfCheck
    public String doResetLogo() {
        this.globalSettings.put("com.atlassian.jira.lookandfeel:usingCustomLogo", (Object)BooleanUtils.toStringTrueFalse((boolean)false));
        this.lookAndFeelProperties.resetDefaultLogo();
        this.autoLookAndFeelManager.backupColorScheme();
        this.autoLookAndFeelManager.generateFromLogo(this.getLoggedInUser());
        this.eventPublisher.publish((Object)new LookAndFeelUpdatedEvent(this.getLoggedInUser(), LookAndFeelUpdatedEvent.Type.RESET_LOGO));
        return this.getRedirect("LookAndFeel!default.jspa");
    }

    @RequiresXsrfCheck
    public String doResetFavicon() {
        this.globalSettings.put("com.atlassian.jira.lookandfeel:usingCustomFavicon", (Object)BooleanUtils.toStringTrueFalse((boolean)false));
        this.lookAndFeelProperties.resetDefaultFavicon();
        this.lookAndFeelProperties.setFaviconChoice(LogoChoice.JIRA);
        this.eventPublisher.publish((Object)new LookAndFeelUpdatedEvent(this.getLoggedInUser(), LookAndFeelUpdatedEvent.Type.RESET_FAVICON));
        return this.getRedirect("LookAndFeel!default.jspa");
    }

    @RequiresXsrfCheck
    public String doUserFormatUpdate() {
        Set set = ActionContext.getParameters().entrySet();
        for (Map.Entry aSet : set) {
            Map.Entry entry = aSet;
            String key = (String)entry.getKey();
            if (!key.startsWith(USER_FORMAT_PREFIX)) continue;
            String type = key.substring(USER_FORMAT_PREFIX.length());
            try {
                this.userFormatTypeConfiguration.setUserFormatKeyForType(type, ((String[])entry.getValue())[0]);
            }
            catch (IllegalArgumentException e) {
                this.addError(USER_FORMAT_PREFIX + type, this.getText("admin.globalsettings.lookandfeel.error.invalid.user.format"));
            }
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        return this.getRedirect("LookAndFeel!default.jspa");
    }

    public String getContextPath() {
        return ActionContext.getRequest().getContextPath();
    }

    @HtmlSafe
    public String getText(String aTextName) {
        return this.i18nHelper.getText(aTextName);
    }

    public String getFaviconUrl() {
        return this.faviconUrl != null ? this.faviconUrl : "";
    }

    public void setFaviconUrl(String faviconUrl) {
        this.faviconUrl = faviconUrl;
    }

    public String getDbBackedDefaultLogoUrl() {
        String defaultUrl = "true".equals(this.globalSettings.get("com.atlassian.jira.lookandfeel:isDefaultLogo")) ? this.ensureURLContext((String)this.globalSettings.get("com.atlassian.jira.lookandfeel:DefaultlogoURL")) : null;
        return defaultUrl;
    }

    private String ensureURLContext(String defaultUrl) {
        if (defaultUrl.startsWith("http")) {
            return defaultUrl;
        }
        return this.getBaseUrl() + defaultUrl;
    }

    public void setLogoUrl(String logoUrl) {
        if (StringUtils.isBlank((String)logoUrl)) {
            logoUrl = "true".equals(this.globalSettings.get("com.atlassian.jira.lookandfeel:isDefaultLogo")) ? (String)this.globalSettings.get("com.atlassian.jira.lookandfeel:DefaultlogoURL") : ((LookAndFeelBean)this.lookAndFeelBean.get()).getLogoUrl();
        }
        this.logoUrl = logoUrl;
    }

    private String getBaseUrl() {
        return this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }

    public int getMaxLogoInHeaderSize() {
        return this.lookAndFeelProperties.getMaxLogoHeight();
    }

    @Deprecated
    public boolean isStudioEnabled() {
        return false;
    }

    @RequiresXsrfCheck
    public String doRefreshResources() throws Exception {
        this.refreshResources();
        return this.getRedirect("LookAndFeel.jspa?refreshResourcesPerformed=true");
    }

    private void refreshResources() {
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.getApplicationProperties());
        lookAndFeelBean.updateSettingsHash();
        this.eventPublisher.publish((Object)new LookAndFeelUpdatedEvent(this.getLoggedInUser(), LookAndFeelUpdatedEvent.Type.REFRESH_RESOURCES));
    }

    private boolean hasChanged(String value1, String value2) {
        return value1 == null ? value2 != null : !value1.equals(value2);
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public String getLookAndFeelVersionNumber() {
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.getApplicationProperties());
        return lookAndFeelBean.getSettingsHash();
    }

    private String getUserFormatTypeName(String type) {
        String typeI18nKey;
        UserFormatModuleDescriptor descriptor = this.userFormatModuleDescriptors.withKey(this.userFormatTypeConfiguration.getUserFormatKeyForType(type));
        if (descriptor != null && StringUtils.isNotEmpty((String)(typeI18nKey = descriptor.getTypeI18nKey()))) {
            return this.getText(typeI18nKey);
        }
        return type;
    }

    private Set<String> getUserFormatTypes() {
        return ImmutableSet.copyOf((Iterable)this.userFormatTypes.get());
    }

    private Collection<UserFormatModuleDescriptor> getUserFormatModuleDescriptorsForType(String type) {
        return ImmutableList.copyOf((Iterable)this.userFormatModuleDescriptors.forType(type));
    }

    private String getUserFormatKey(String type) {
        UserFormatModuleDescriptor descriptor = this.userFormatModuleDescriptors.withKey(this.userFormatTypeConfiguration.getUserFormatKeyForType(type));
        if (descriptor != null) {
            return descriptor.getCompleteKey();
        }
        return type;
    }

    public boolean hasUserFormatsToEdit() {
        Set<String> types = this.getUserFormatTypes();
        for (String type1 : types) {
            String type = type1;
            if (this.getUserFormatModuleDescriptorsForType(type).size() <= 1) continue;
            return true;
        }
        return false;
    }

    public String getAutoUpdateColorsLinkAsHtml() {
        return this.getText("jira.lookandfeel.updatecolors.link", "<a href='" + this.getContextPath() + "/secure/admin/LookAndFeel!autoUpdateColors.jspa?atl_token=" + this.getXsrfToken() + "'>", "</a>");
    }
}

