/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lookandfeel;

import com.atlassian.jira.bc.admin.ApplicationPropertiesService;
import com.atlassian.jira.bc.admin.ApplicationProperty;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.lookandfeel.HSBColor;
import com.atlassian.jira.lookandfeel.ImageInfo;
import com.atlassian.jira.lookandfeel.upload.UploadService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class AutoLookAndFeelManager {
    private static final HSBColor LIGHT_TEXT = new HSBColor(Color.white);
    private static final HSBColor DARK_TEXT = new HSBColor(new Color(41, 41, 41));
    private static final String JUST_UPDATED_KEY = "lookandfeel.auto.just.updated";
    private static final String[] COLOR_KEYS = new String[]{"jira.lf.top.bgcolour", "jira.lf.top.hilightcolour", "jira.lf.top.separator.bgcolor", "jira.lf.menu.bgcolour", "jira.lf.hero.button.base.bg.colour", "jira.lf.top.textcolour", "jira.lf.top.texthilightcolour", "jira.lf.menu.textcolour", "jira.lf.hero.button.text.colour"};
    private final ApplicationProperties applicationProperties;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final UserPropertyManager userPropertyManager;
    private final UploadService uploadService;
    private final PluginSettings globalSettings;

    public AutoLookAndFeelManager(ApplicationProperties applicationProperties, ApplicationPropertiesService applicationPropertiesService, UserPropertyManager userPropertyManager, UploadService uploadService, PluginSettingsFactory pluginSettingsFactory) {
        this.applicationProperties = applicationProperties;
        this.applicationPropertiesService = applicationPropertiesService;
        this.userPropertyManager = userPropertyManager;
        this.uploadService = uploadService;
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public void generateFromLogo(ApplicationUser user) {
        ImageInfo logoInfo = this.getLogoInfo();
        if (logoInfo.isTransparentBackground()) {
            if (logoInfo.isMostlyWhite()) {
                this.applyDefaultColors();
            } else if (logoInfo.isTooBrightForWhiteBackground() && logoInfo.getPredominantColor() != null) {
                this.setBaseColor(logoInfo.getPredominantColor().saturateByAmount(30).darkenByAmount(30));
            } else {
                this.setBaseColors(new HSBColor(Color.white), logoInfo.getPredominantColor());
            }
        } else {
            HSBColor base = logoInfo.getBackgroundColor();
            if (ImageInfo.isMonochrome(base) || base.getSaturation() < 30) {
                this.setBaseColors(base, logoInfo.getPredominantColor());
            } else {
                this.setBaseColor(base);
            }
        }
        this.setJustUpdated(user, true);
    }

    public boolean isJustUpdated(ApplicationUser user) {
        boolean justUpdated = this.userPropertyManager.getPropertySet(user).getBoolean(JUST_UPDATED_KEY);
        if (justUpdated) {
            this.setJustUpdated(user, false);
        }
        return justUpdated;
    }

    public void setJustUpdated(ApplicationUser user, boolean justUpdated) {
        this.userPropertyManager.getPropertySet(user).setBoolean(JUST_UPDATED_KEY, justUpdated);
    }

    public boolean isDefaultColorScheme() {
        for (String key : COLOR_KEYS) {
            if (this.isDefaultColor(key)) continue;
            return false;
        }
        return true;
    }

    public boolean isDefaultColor(String key) {
        ApplicationProperty property = this.applicationPropertiesService.getApplicationProperty(key);
        return property.getMetadata().getDefaultValue().equals(property.getCurrentValue());
    }

    public void applyDefaultColors() {
        for (String key : COLOR_KEYS) {
            this.applyDefaultColor(key);
        }
    }

    public void applyDefaultColor(String key) {
        ApplicationProperty property = this.applicationPropertiesService.getApplicationProperty(key);
        if (!property.getMetadata().getDefaultValue().equals(property.getCurrentValue())) {
            this.applicationProperties.setString(key, property.getMetadata().getDefaultValue());
        }
    }

    public void backupColorScheme() {
        for (String key : COLOR_KEYS) {
            this.backupColor(key);
        }
    }

    public void backupColor(String key) {
        this.applicationProperties.setString(key + ".backup", this.applicationProperties.getString(key));
    }

    public void restoreBackupColorScheme() {
        for (String key : COLOR_KEYS) {
            this.restoreBackupColor(key);
        }
    }

    public void restoreBackupColor(String key) {
        String backupValue = this.applicationProperties.getString(key + ".backup");
        if (backupValue != null) {
            this.applicationProperties.setString(key, backupValue);
        } else {
            this.applyDefaultColor(key);
        }
    }

    public void setBaseColor(HSBColor base) {
        this.setBaseColors(base, this.getHeroButtonBackground(base));
    }

    public void setBaseColors(HSBColor base, HSBColor heroButtonBackground) {
        if (heroButtonBackground == null) {
            heroButtonBackground = this.getHeroButtonBackground(base);
        }
        HSBColor baseHighlight = this.getBaseHighlight(heroButtonBackground);
        HSBColor separator = this.getSeparator(base, heroButtonBackground);
        this.applicationProperties.setString("jira.lf.top.bgcolour", base.getHexString());
        this.applicationProperties.setString("jira.lf.top.hilightcolour", baseHighlight.getHexString());
        this.applicationProperties.setString("jira.lf.top.separator.bgcolor", separator.getHexString());
        this.applicationProperties.setString("jira.lf.menu.bgcolour", baseHighlight.getHexString());
        this.applicationProperties.setString("jira.lf.hero.button.base.bg.colour", heroButtonBackground.getHexString());
        this.applicationProperties.setString("jira.lf.top.textcolour", this.getTextColor(base).getHexString());
        this.applicationProperties.setString("jira.lf.top.texthilightcolour", this.getTextColor(baseHighlight).getHexString());
        this.applicationProperties.setString("jira.lf.menu.textcolour", this.getTextColor(baseHighlight).getHexString());
        this.applicationProperties.setString("jira.lf.hero.button.text.colour", this.getTextColor(heroButtonBackground).getHexString());
    }

    private HSBColor getBaseHighlight(HSBColor heroButtonBackground) {
        return heroButtonBackground.darkenByAmount(13);
    }

    private HSBColor getSeparator(HSBColor base, HSBColor heroButtonBackground) {
        if (ImageInfo.isMonochrome(base) && !ImageInfo.isMonochrome(heroButtonBackground)) {
            return heroButtonBackground.darkenByAmount(45).desaturateByAmount(25);
        }
        return base.darkenByAmount(18).desaturateByAmount(30);
    }

    private HSBColor getHeroButtonBackground(HSBColor base) {
        HSBColor result = base.getBrightness() <= 73 ? base.lightenByAmount(27) : base.darkenByAmount(27);
        return result.desaturateByAmount(5);
    }

    private HSBColor getTextColor(HSBColor background) {
        float darkTextDiff;
        float lightTextDiff = Math.abs(background.getPerceivedBrightness() - LIGHT_TEXT.getPerceivedBrightness());
        return lightTextDiff > (darkTextDiff = Math.abs(background.getPerceivedBrightness() - DARK_TEXT.getPerceivedBrightness())) ? LIGHT_TEXT : DARK_TEXT;
    }

    private ImageInfo getLogoInfo() {
        try {
            BufferedImage image = ImageIO.read(this.getLogoInputStream());
            return new ImageInfo(image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream getLogoInputStream() throws IOException {
        if ("true".equals(this.globalSettings.get("com.atlassian.jira.lookandfeel:usingCustomLogo"))) {
            File logoDirectory = this.uploadService.getLogoDirectory();
            return new FileInputStream(new File(logoDirectory, "jira-logo-scaled.png"));
        }
        return ServletContextProvider.getServletContext().getResourceAsStream("/images/icon-jira-logo.png");
    }
}

