/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.less.impl;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.less.impl.DynamicLookAndFeelUtil;
import com.atlassian.lesscss.spi.UriResolverStateChangedEvent;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.net.URI;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicLookAndFeelEventForwarder
implements InitializingBean,
DisposableBean {
    private final PluginEventManager pluginEventManager;

    @Autowired
    public DynamicLookAndFeelEventForwarder(@ComponentImport PluginEventManager pluginEventManager) {
        this.pluginEventManager = pluginEventManager;
    }

    @EventListener
    public void onStateChanged(LookAndFeelBean.LookAndFeelChangedEvent event) {
        this.pluginEventManager.broadcast((Object)new DynamicUriResolverStateChangedEvent("look-and-feel"));
    }

    public void destroy() throws Exception {
        this.pluginEventManager.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.pluginEventManager.register((Object)this);
    }

    public static class DynamicUriResolverStateChangedEvent
    extends UriResolverStateChangedEvent {
        public DynamicUriResolverStateChangedEvent(Object source) {
            super(source);
        }

        public boolean hasChanged(URI uri) {
            return DynamicLookAndFeelUtil.isDynamicLookAndFeelURI(uri);
        }
    }
}

