AJS.test.require([
    "com.atlassian.jira.jira-issue-nav-plugin:testutils",
    "com.atlassian.jira.jira-issue-nav-plugin:issuenav"
], function() {
    "use strict";

    require([
        "jira/issues/views/details/analytics"
    ], function(
        Analytics
    ) {
        module("jira/issues/views/details/analytics", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
                this.sandbox.stub(JIRA.Issues.Application, "execute");
            },

            teardown: function() {
                this.sandbox.restore();
            }
        });

        test("Analytics for viewIssue trigger a kickass.viewIssue event with issueMatchesProjectContext:true when the project key matches the issue key", function() {
            Analytics.triggerViewIssue({
                issueId: 100,
                issueKey: 'TEST-123',
                loadReason: 'reason',
                duration: 50,
                projectId: 101,
                projectType: 'software',
                projectKey: 'TEST'
            });

            sinon.assert.calledOnce(JIRA.Issues.Application.execute);
            sinon.assert.calledWith(JIRA.Issues.Application.execute, "analytics:trigger", "kickass.viewIssue", {
                issueId: 100,
                duration: 50,
                loadReason: 'reason',
                loadedFromDom: false,
                source: "jira.issuenav.global",
                projectId: 101,
                projectType: 'software',
                issueMatchesProjectContext: true
            });
        });

        test("Analytics for viewIssue trigger a kickass.viewIssue event with issueMatchesProjectContext:false when the project key doesn't match the issue key", function() {
            Analytics.triggerViewIssue({
                issueId: 100,
                issueKey: 'TEST-123',
                loadReason: 'reason',
                duration: 50,
                projectId: 101,
                projectType: 'software',
                projectKey: 'OTHER'
            });

            sinon.assert.calledOnce(JIRA.Issues.Application.execute);
            sinon.assert.calledWith(JIRA.Issues.Application.execute, "analytics:trigger", "kickass.viewIssue", {
                issueId: 100,
                duration: 50,
                loadReason: 'reason',
                loadedFromDom: false,
                source: "jira.issuenav.global",
                projectId: 101,
                projectType: 'software',
                issueMatchesProjectContext: false
            });
        });

        test("Analytics for viewIssue trigger a kickass.viewIssue event with issueMatchesProjectContext:false when the issue key is null", function() {
            Analytics.triggerViewIssue({
                issueId: 100,
                issueKey: null,
                loadReason: 'reason',
                duration: 50,
                projectId: 101,
                projectType: 'software',
                projectKey: 'TEST'
            });

            sinon.assert.calledOnce(JIRA.Issues.Application.execute);
            sinon.assert.calledWith(JIRA.Issues.Application.execute, "analytics:trigger", "kickass.viewIssue", {
                issueId: 100,
                duration: 50,
                loadReason: 'reason',
                loadedFromDom: false,
                source: "jira.issuenav.global",
                projectId: 101,
                projectType: 'software',
                issueMatchesProjectContext: false
            });
        });
    });
});
