AJS.test.require([
    "com.atlassian.jira.jira-issue-nav-plugin:testutils",
    "com.atlassian.jira.jira-issue-nav-plugin:issuenav"
], function() {
    "use strict";

    require([
        "jira/issues/views/details"
    ], function(
        Details
    ) {
        module("jira/issues/views/details", {
            setup: function() {
                var search = new JIRA.Issues.MockSearchModule();
                search.getResults().setSelectedIssue(new JIRA.Issues.SimpleIssue());

                this.details = new Details({
                    search: search,
                    searchContainer: jQuery("<div class='navigator-content'></div>"),
                    fullScreenIssue: JIRA.Issues.TestUtils.mockFullScreenIssue()
                });
            }
        });

        test("focusIssueList() delegates to the internal component DetailsLayout", function() {
            this.spy(this.details.detailsLayout, "focusList");

            this.details.focusIssueList();

            sinon.assert.calledOnce(this.details.detailsLayout.focusList);
        });

        test("focusIssueEditor() delegates to the internal component DetailsLayout", function() {
            this.spy(this.details.detailsLayout, "focusEditor");

            this.details.focusIssueEditor();

            sinon.assert.calledOnce(this.details.detailsLayout.focusEditor);
        });
    });
});
