AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:viewissue"],function(){module("IssueNavLoader",{setup:function(){this.sandbox=sinon.sandbox.create();this.context=AJS.test.mockableModuleContext();this.reloadSpy=this.sandbox.spy();this.context.mock("jira/util/browser",{reloadViaWindowLocation:this.reloadSpy});this.issueNavLoader=this.context.require("jira/issues/viewissue/issuenavloader");this.requireCallback=function(){};this.sandbox.stub(WRM,"require",function(b,a){if(b[0]==="wrc!com.atlassian.jira.jira-issue-nav-plugin:issuenav"){this.requireCallback=a}}.bind(this));this.navigationCallback=function(){};this.sandbox.stub(JIRA.Issues.Application,"on",function(b,c,a){a=a||this;if(b==="navigation:stateChanged"){this.navigationCallback=c.bind(a)}}.bind(this));this.sandbox.spy(JIRA.Issues.Application,"execute");this.issueNavCreateSpy=this.sandbox.stub(JIRA.Issues.GlobalIssueNavCreator,"create");this.clock=sinon.useFakeTimers()},teardown:function(){this.sandbox.restore();this.clock.restore()}});test("Issue Search is initialized after resources are fetched",function(){this.issueNavLoader.loadIssueNav();ok(this.issueNavCreateSpy.notCalled,"Issue Search Creator is called");this.requireCallback();ok(this.issueNavCreateSpy.calledOnce,"Issue Search Creator is called")});test("Navigation is repeated after resources are fetched",function(){var b={selectedIssueType:"TEST-1"};var a={reset:true};this.issueNavLoader.loadIssueNav();this.navigationCallback(b,a);this.requireCallback();ok(this.issueNavCreateSpy.calledOnce,"Issue Search Creator is called");ok(JIRA.Issues.Application.execute.calledTwice,"Navigation is repeated");ok(JIRA.Issues.Application.execute.calledWith("analytics:trigger","kickass.viewIssueNavigationRequested"),"Analytics event is triggered");ok(JIRA.Issues.Application.execute.calledWithExactly("navigation:updateState",b,{replace:true,forceRefresh:true,reset:true}),"Navigation is repeated")});test("Only last navigation is repeated",function(){var b={selectedIssueType:"TEST-1"};var a={selectedIssueType:"TEST-2",jql:"JQL"};this.issueNavLoader.loadIssueNav();this.navigationCallback(b);this.navigationCallback(a);this.requireCallback();ok(JIRA.Issues.Application.execute.calledThrice,"Navigation is repeated");ok(JIRA.Issues.Application.execute.calledWith("analytics:trigger","kickass.viewIssueNavigationRequested"),"Analytics event is triggered");ok(JIRA.Issues.Application.execute.calledWith("navigation:updateState",a),"Navigation is repeated")});test("Full page reload is performed if resources aren't fetched",function(){var a="http://jira";var c="browse/TEST-1";var b={selectedIssueType:"TEST-1",toUrl:this.sandbox.stub().returns(c)};this.sandbox.stub(AJS,"contextPath").returns(a);this.issueNavLoader.loadIssueNav();this.navigationCallback(b);this.clock.tick(this.issueNavLoader.SPA_NAVIGATION_TIMEOUT+100);ok(this.reloadSpy.calledOnce,"Location is changed after timeout");ok(this.reloadSpy.calledWithExactly(a+"/"+c),"Location is changed to proper url")});test("Full page reload is performed if resources aren't fetched",function(){var a={selectedIssueType:"TEST-1",toUrl:this.sandbox.stub().returns("")};this.issueNavLoader.loadIssueNav();this.clock.tick(this.issueNavLoader.SPA_NAVIGATION_TIMEOUT+100);ok(this.reloadSpy.notCalled,"Location is changed only when user requests state change");this.navigationCallback(a);this.clock.tick(this.issueNavLoader.SPA_NAVIGATION_TIMEOUT-1);ok(this.reloadSpy.notCalled,"Location is changed only when user requests state change");this.clock.tick(1);ok(this.reloadSpy.calledOnce,"Location is changed only when user requests state change")})});