AJS.test.require("com.atlassian.jira.jira-issue-nav-plugin:viewissue",function(){module("analytics",{setup:function(){this.sandbox=sinon.sandbox.create();this.orignalApplication=JIRA.Issues.Application;JIRA.Issues.Application=new JIRA.Marionette.Application();this.app=JIRA.Issues.Application;JIRA.Issues.AnalyticsLoader.init()},teardown:function(){this.sandbox.restore();JIRA.Issues.Application=this.orignalApplication}});test("Should trigger kickass.viewIssue analytics event on loadComplete only when issue is not fetched from cache",function(){this.sandbox.stub(JIRA.Issues.Application,"execute");var a={getId:function(){return 123},getProjectId:function(){return 456},getProjectKey:function(){return"TEST"},getProjectType:function(){return"software"}};this.app.trigger("issueEditor:loadComplete",a,{fromCache:false});ok(this.app.execute.calledTwice,"Application.execute was called twice");ok(this.app.execute.firstCall.calledWith("analytics:trigger","kickass.viewIssue",{duration:undefined,loadReason:undefined,issueId:123,loadedFromDom:false,projectId:456,projectType:"software",issueMatchesProjectContext:false}),"kickass.viewIssue event was fired");ok(this.app.execute.calledWith("analytics:trigger","kickass.issueLoadDuration"),"kickass.issueLoadDuration event was fired");this.app.execute.reset();this.app.trigger("issueEditor:loadComplete",a,{fromCache:true});ok(this.app.execute.calledOnce,"Application.execute was called once");ok(this.app.execute.calledWith("analytics:trigger","kickass.issueLoadDuration"),"kickass.issueLoadDuration event was fired")});test("Should trigger kickass.viewIssue analytics event on render only when issue is loaded from dom",function(){this.sandbox.stub(JIRA.Issues.Application,"execute");this.app.trigger("issueEditor:render",null,{loadedFromDom:false});ok(!this.app.execute.called,"none of the events should be fired");this.app.execute.reset();this.app.trigger("issueEditor:render",null,{loadedFromDom:true,issueId:111,issueKey:"TEST-1",projectId:1,projectKey:"TEST",projectType:"business"});ok(this.app.execute.calledOnce,"Application.execute was called once");ok(this.app.execute.calledWith("analytics:trigger","kickass.viewIssue",{issueId:111,loadedFromDom:true,projectId:1,projectType:"business",issueMatchesProjectContext:true}),"kickass.viewIssue event was fired with the right parameters")});test("Should trigger kickass.viewIssue analytics event on render only when issue is loaded from dom and issue key is null",function(){this.sandbox.stub(JIRA.Issues.Application,"execute");this.app.trigger("issueEditor:render",null,{loadedFromDom:true,issueId:111,issueKey:null,projectId:1,projectKey:"TEST",projectType:"business"});ok(this.app.execute.calledOnce,"Application.execute was called once");ok(this.app.execute.calledWith("analytics:trigger","kickass.viewIssue",{issueId:111,loadedFromDom:true,projectId:1,projectType:"business",issueMatchesProjectContext:false}),"kickass.viewIssue event was fired with the right parameters")});test("Should trigger kickass.viewIssue analytics event on render only when issue is loaded from dom and issue key doesn't match project context",function(){this.sandbox.stub(JIRA.Issues.Application,"execute");this.app.trigger("issueEditor:render",null,{loadedFromDom:true,issueId:111,issueKey:"ANOTHER-123",projectId:1,projectKey:"TEST",projectType:"business"});ok(this.app.execute.calledOnce,"Application.execute was called once");ok(this.app.execute.calledWith("analytics:trigger","kickass.viewIssue",{issueId:111,loadedFromDom:true,projectId:1,projectType:"business",issueMatchesProjectContext:false}),"kickass.viewIssue event was fired with the right parameters")});test("Should trigger kickass.inlineEdit analytics event when a field has been saved",function(){this.sandbox.stub(JIRA.Issues.Application,"execute");var a={issueId:123,savedFieldIds:["summary"],savedFieldTypes:["field-type-1"],duration:456};this.app.trigger("issueEditor:saveSuccess",a);ok(this.app.execute.calledOnce,"Application.execute was called once");ok(this.app.execute.calledWith("analytics:trigger","kickass.inlineEdit"),"kickass.inlineEdit event was fired");ok(this.app.execute.calledWith("analytics:trigger","kickass.inlineEdit",a),"kickass.inlineEdit event includes the properties")});test("Should trigger kickass.inlineEdit.start analytics event when a field has been selected for edit",function(){this.sandbox.stub(JIRA.Issues.Application,"execute");var a={issueId:123,fieldId:"summary",fieldType:"some:type"};this.app.trigger("issueEditor:editField",a);ok(this.app.execute.calledOnce,"Application.execute was called once");ok(this.app.execute.calledWith("analytics:trigger","kickass.inlineEdit.start"),"kickass.inlineEdit.start event was fired");ok(this.app.execute.calledWith("analytics:trigger","kickass.inlineEdit.start",a),"kickass.inlineEdit.start event includes the properties")});test("Should trigger kickass.inlineEdit.cancel analytics event when a field has been closed for edit",function(){this.sandbox.stub(JIRA.Issues.Application,"execute");var a={issueId:123,fieldId:"summary",fieldType:"some:type"};this.app.trigger("issueEditor:editFieldCancel",a);ok(this.app.execute.calledOnce,"Application.execute was called once");ok(this.app.execute.calledWith("analytics:trigger","kickass.inlineEdit.cancel"),"kickass.inlineEdit.cancel event was fired");ok(this.app.execute.calledWith("analytics:trigger","kickass.inlineEdit.cancel",a),"kickass.inlineEdit.cancel event includes the properties")})});