AJS.test.require("com.atlassian.jira.jira-issue-nav-plugin:common", function(){
    "use strict";

    var LoginUtils = require('jira/issues/utils/login');

    module('jira/issues/utils/login', {
        setup: function() {
            sinon.stub(LoginUtils, "_getWindowLocation");
        },
        teardown: function() {
            LoginUtils._getWindowLocation.restore();
        }
    });

    test("redirectUrl", function() {
        var r = LoginUtils.redirectUrl;

        equal(AJS.contextPath() + "/login.jsp?os_destination=%2Fissues%2F", r("/issues/"));
        equal(AJS.contextPath() + "/login.jsp?os_destination=%2Fissues%2F%3F", r("/issues/?"));
        equal(AJS.contextPath() + "/login.jsp?os_destination=%2Fissues%2F%3Fa%3Db", r("/issues/?a=b"));
    });

    test("currentContextRelativePath", function() {
        var r = function() { return LoginUtils.currentContextRelativePath(); };

        LoginUtils._getWindowLocation.returns({
            href: "http://jira" + AJS.contextPath() + "/blah",
            protocol: "http:",
            host: "jira"
        });

        equal(r(), "/blah");

        LoginUtils._getWindowLocation.returns({
            href: "http://jira:2990" + AJS.contextPath() + "/blah?que=ry&str=ing#hashcake",
            protocol: "http:",
            host: "jira:2990"
        });

        equal(r(), "/blah?que=ry&str=ing#hashcake");
    });

    test("redirectUrlToCurrent", function() {
        var r = function() { return LoginUtils.redirectUrlToCurrent(); };

        LoginUtils._getWindowLocation.returns({
            href: "http://example.com" + AJS.contextPath() + "/blah",
            protocol: "http:",
            host: "example.com"
        });

        equal(r(), AJS.contextPath() + "/login.jsp?os_destination=%2Fblah");

        LoginUtils._getWindowLocation.returns({
            href: "http://example.com:2990" + AJS.contextPath() + "/blah/?que=ry&str=ing#hashcake",
            protocol: "http:",
            host: "example.com:2990"
        });

        equal(r(), AJS.contextPath() + "/login.jsp?os_destination=%2Fblah%2F%3Fque%3Dry%26str%3Ding%23hashcake");
    });

});
