(function() {
    "use strict";

    AJS.namespace("JIRA.Issues.MockFilterModule");

    /**
     * A mock <tt>JIRA.Issues.FilterModule</tt> object for use in tests.
     */
    JIRA.Issues.MockFilterModule = JIRA.Issues.BaseModel.extend({
        initialize: function() {
            this.filtersComponent = new JIRA.Components.Filters();
            this.getFilterById = sinon.stub();
            this.getFilterById.returns(new jQuery.Deferred().promise());
        },

        initSystemFilters: function() {
            return new jQuery.Deferred().resolve().promise();
        },

        canEditColumns: function() {
            return true;
        },

        updateFilterHeader: function() {

        }
    });
}());
