AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:testutils","com.atlassian.jira.jira-issue-nav-plugin:issuenav"],function(){var l=require("jquery");var d=require("wrm/context-path");var h=require("underscore");var f=require("jira/ajs/keyboardshortcut/keyboard-shortcut");var k=require("jira/util/events/reasons");var c=require("jira/util/events/types");var g=require("jira/issues/components/filters");var b=require("jira/issues/application");var j=require("jira/issues/search/filters/filter-module");var a=require("jira/issues/search/filters/filter-panel-view");var e=require("jira/issues/test/utils");var i=require("jira/util/events");module("jira/issues/search/filters/filter-panel-view",{setup:function(){this.sandbox=sinon.sandbox.create();this.sandbox.useFakeServer();this.server=this.sandbox.server;this.el=l("<div></div>");this.searchPageModule=e.mockSearchPageModule();localStorage.removeItem("issues.sidebar.docked");this.filterData=[{id:10000,name:"Sample Search 1",jql:"project = HSP"},{id:10001,name:"Sample Search 2",jql:"project = TST"},{id:10002,name:"Sample Search 3",jql:"project = HSP and type = bug"}];this.getShortcutKeysStub=this.sandbox.stub(f,"getKeyboardShortcutKeys").returns("[");this.openTemplate=this.sandbox.spy(a.prototype,"template");this.closedTemplate=this.sandbox.spy(a.prototype,"collapsedTemplate");this.favFiltersUrl=g.Collections.FavouriteFilters.prototype.url;this.sandbox.stub(b,"request").withArgs("issueEditor:canDismissComment").returns(true)},createFilterModule:function(m,n){this.filterModule=new j({systemFilters:m||[],searchPageModule:this.searchPageModule});if(m&&m.length){this.filterModule.initSystemFilters()}if(!n){h.last(this.server.requests).respond(200)}this.searchPageModule.filterModule=this.filterModule;this.filterPanelModel=this.filterModule.filterPanelModel;this.filterPanelModel.isDocked=this.sandbox.stub().returns(true);this.filterPanelView=this.filterModule.createView({$filterPanelEl:this.el})},teardown:function(){this.server.respond();this.server.restore();this.sandbox.restore();this.el.remove()}});test("Render fallback content when no filters exist",function(){this.createFilterModule();this.filterPanelView.render();equal(this.filterPanelView.$(".saved-filter").length,0,"Filter list <ul> is not rendered");ok(this.filterPanelView.$(".filter-info").length>0,"Search","Fallback content is rendered")});test("Favourite filters shows correct message for logged in user",function(){e.stubGetLoggedInUser("my name is james bond. james bond.");this.createFilterModule();this.server.respondWith("GET",new RegExp(this.favFiltersUrl),[200,{"Content-Type":"application/json"},"[]"]);this.server.respond();this.filterPanelView.render();ok(this.filterPanelView.$el.text().indexOf("issue.nav.filters.fav.empty")!==-1,"Correct message shown.")});test("Favourite filters shows correct message for anon user",function(){this.stub(AJS,"format",function(){return h.toArray(arguments).concat(",")});e.stubGetLoggedInUser("");this.createFilterModule();this.server.respondWith("GET",new RegExp(this.favFiltersUrl),[200,{"Content-Type":"application/json"},"[]"]);this.server.respond();this.filterPanelView.render();ok(this.filterPanelView.$el.find(".favourite-filters").text().indexOf("issue.nav.filters.fav.anonymous")!==-1,"Correct message shown.");var m=this.filterPanelView.$el.find(".favourite-filters a");ok(m.attr("href").indexOf(d()+"/login.jsp?")===0,"Contains a login link")});test("System filters render login links when no logged in user",function(){e.stubGetLoggedInUser("");this.createFilterModule([{id:"sys-filter-a",requiresLogin:true},{id:"sys-filter-b",requiresLogin:false}]);this.filterPanelView.render();var n=this.filterPanelView.$el.find("[data-id='sys-filter-a']");equal(n.attr("href"),d()+"/login.jsp?os_destination=%2Fissues%2F%3Ffilter%3Dsys-filter-a");var m=this.filterPanelView.$el.find("[data-id='sys-filter-b']");equal(m.attr("href"),d()+"/issues/?filter=sys-filter-b")});test("System filters render login links when there is a logged in user",function(){e.stubGetLoggedInUser("scott");this.createFilterModule([{id:"sys-filter-a",requiresLogin:true},{id:"sys-filter-b",requiresLogin:false}]);this.filterPanelView.render();var n=this.filterPanelView.$el.find("[data-id='sys-filter-a']");equal(n.attr("href"),d()+"/issues/?filter=sys-filter-a");var m=this.filterPanelView.$el.find("[data-id='sys-filter-b']");equal(m.attr("href"),d()+"/issues/?filter=sys-filter-b")});test("Hover state is maintained after opening the actions dialog",function(){this.createFilterModule();this.filterModule.filtersComponent.favouriteFiltersCollection.add(new g.Models.Filter({id:"1",jql:"",name:"Happy Little Filter"}));this.filterPanelView.render();this.filterPanelView.$el.appendTo("#qunit-fixture");this.filterPanelView.$el.find("a.filter-actions").click();ok(this.filterPanelView.$el.find(".favourite-filters li").hasClass("hover"),"List item has hover class.");ok(this.filterPanelView.$el.find(".favourite-filters li a span").hasClass("active"),"Dropdown button has active class.");this.filterPanelView.$el.find("a.filter-actions").click();ok(!this.filterPanelView.$el.find(".favourite-filters li").hasClass("hover"),"List item doesn't have hover class.");ok(!this.filterPanelView.$el.find(".favourite-filters li a span").hasClass("active"),"Dropdown button doesn't have active class.")});test("makes render call when initialized",function(){var m=this.sandbox.spy(a.prototype,"render");this.createFilterModule();equal(m.callCount,1,"should be rendered when initialize method called")});test("renders open template when docked",function(){this.createFilterModule();equal(this.openTemplate.callCount,1);equal(this.closedTemplate.callCount,0)});test("rendering open template should trigger a JIRA.Events.NEW_CONTENT_ADDED event",function(){var m=this.sandbox.spy(i,"trigger");this.createFilterModule();equal(m.callCount,1,"First event triggered for implicit render (loading values)");var n=m.firstCall;equal(n.args[0],c.NEW_CONTENT_ADDED,"Event is JIRA.Events.NEW_CONTENT_ADDED");equal(typeof n.args[1][1],"string","Ensure event has a reason argument");equal(n.args[1][1],k.filterPanelOpened,"Event reason is JIRA.CONTENT_ADDED_REASON.filterPanelOpened")});test("Clicking on NewSearch triggers the filterSelected event",function(){this.createFilterModule();this.searchPageModule.resetToBlank=l.noop;var m=sinon.spy();this.filterPanelView.on("filterSelected",m);this.filterPanelView._renderOpen();this.filterPanelView.$el.find("a.new-search").click();equal(m.callCount,1,"The event 'filterSelected' is triggered");ok(m.calledWith(null),"No filter is specified in the event payload")});test("Changing the selected filter clears the previously active filter",function(){var m=new g.Models.Filter({id:"1",jql:"",name:"Happy Little Filter"});var n=new g.Models.Filter({id:"2",jql:"",name:"My new filter"});this.createFilterModule([m,n]);this.filterPanelView.render();this.filterPanelModel.set("activeFilter",m);this.filterPanelModel.set("activeFilter",n);ok(!this.filterPanelView.$el.find("a.filter-link[data-id=1]").hasClass("active"))});test("Clearing the selected filter is reflected in the UI",function(){var m=new g.Models.Filter({id:"1",jql:"",name:"Happy Little Filter"});this.createFilterModule([m]);this.filterPanelView.render();this.filterPanelModel.set("activeFilter",m);this.filterPanelModel.set("activeFilter",null);ok(!this.filterPanelView.$el.find("a.filter-link[data-id=1]").hasClass("active"))});test("By default, no filter is selected in the UI",function(){var m=new g.Models.Filter({id:"1",jql:"",name:"Happy Little Filter"});this.createFilterModule([m]);this.filterPanelView.render();ok(!this.filterPanelView.$el.find("a.filter-link[data-id=1]").hasClass("active"))});test("favourite filters should render special message if failed to retrieve from server",function(){this.server.respondWith("GET",new RegExp(this.favFiltersUrl),[400,{"Content-Type":"application/json"},'{"errorMessage": "Failed for some reason"}']);this.createFilterModule([],true);equal(this.el.find(".favourite-filters").text(),"issue.nav.filters.fav.loading","Should tell the user that we're loading from the server");this.server.respond();equal(this.el.find(".favourite-filters").text(),"issue.nav.filters.fav.error","Should tell user there was a problem")});test("favourite filters should persist special message if sidebar collapsed and expanded",function(){this.createFilterModule([],true);this.server.respondWith("GET",new RegExp(this.favFiltersUrl),[400,{"Content-Type":"application/json"},'{"errorMessage": "Failed for some reason"}']);this.server.respond();equal(this.el.find(".favourite-filters").text(),"issue.nav.filters.fav.error","Should tell user there was a problem");this.filterPanelModel.isDocked=sinon.stub().returns(false);this.filterPanelView.render();this.filterPanelModel.isDocked=sinon.stub().returns(true);this.filterPanelView.render();equal(this.el.find(".favourite-filters").text(),"issue.nav.filters.fav.error","Should still tell user there was a problem")})});