AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:testutils", "com.atlassian.jira.jira-issue-nav-plugin:issuenav"], function() {
    "use strict";

    var Browser = require("jira/issues/search/filters/browse");
    var FilterPanelModel = require("jira/issues/search/filters/filter-panel-model");

    module("jira/issues/search/filters/filter-panel-model", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(Browser, 'getWindowWidth');

            this.storage = {
                getItem: this.sandbox.stub(),
                removeItem: this.sandbox.stub(),
                setItem: this.sandbox.stub()
            };

            this.filterPanelModel = new FilterPanelModel({}, {
                storage: this.storage
            });
        },

        teardown: function() {
            this.sandbox.restore();
        }
    });

    test("Default state is docked", function() {
        equal(this.filterPanelModel.isDocked(), true, "Expected filter panel to be docked");
    });

    test("User preference overrides default docked state", function() {
        this.storage.getItem.returns("false");
        equal(this.filterPanelModel.isDocked(), false, "Expected filter panel to be undocked");
    });

    test("User preference overrides default unddocked state", function() {
        this.storage.getItem.returns("true");
        equal(this.filterPanelModel.isDocked(), true, "Expected filter panel to be docked");
    });
});
