AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:testutils","com.atlassian.jira.jira-issue-nav-plugin:issuenav"],function(){var g=require("jquery");var b=require("jira/issues/components/filters");var d=require("jira/issues/application");var f=require("jira/issues/search/filters/filter-module");var e=require("jira/issues/search/filters/filter-panel-view");var a=require("jira/issues/test/utils");var c=require("jira/issues/test/mock-latest-search-store");module("jira/issues/search/filters/filter-module",{setup:function(){localStorage.removeItem("jira.issue.navigator.latest.search");AJS.keys={shortcuts:[{moduleKey:"toggle-filter-panel",keys:"["}]};this.sandbox=sinon.sandbox.create({properties:["spy","stub","server","requests"],useFakeTimers:false,useFakeServer:true});this.server=this.sandbox.server;this.sandbox.stub(e.prototype,"render");this.searchPageModule=a.mockSearchPageModule();this.LatestSearchStore=new c();this.searchPageModule.LatestSearchStore=this.LatestSearchStore;d.start();this.el=g("<div></div>");this.filterModule=new f({searchPageModule:this.searchPageModule,systemFilters:[{id:-1,name:"My open issues",jql:"assignee = currentUser() AND resolution = Unresolved ORDER BY updatedDate DESC",isSystem:true,sharePermissions:[],requiresLogin:true},{id:-2,name:"Reported by me",jql:"reporter = currentUser() ORDER BY createdDate DESC",isSystem:true,sharePermissions:[],requiresLogin:true},{id:-3,name:"Recently viewed",jql:"issuekey in issueHistory() ORDER BY lastViewed DESC",isSystem:true,sharePermissions:[]},{id:-4,name:"All issues",jql:"ORDER BY createdDate DESC",isSystem:true,sharePermissions:[]}]});this.searchPageModule.filterModule=this.filterModule;var h=[{id:10000,name:"Sample Search 1",jql:"project = HSP",sharePermissions:[]},{id:10001,name:"Sample Search 2",jql:"project = TST",sharePermissions:[]},{id:10002,name:"Sample Search 3",jql:"project = HSP and type = bug",sharePermissions:[]}];this.filterPanelView=this.filterModule.createView({$filterPanelEl:this.el});this.filterModule.filtersComponent.favouriteFiltersCollection.add(h);this._getFilter=function(i){return this.filterModule.filtersComponent.favouriteFiltersCollection.get(i)};this._selectFilter=function(j){var i=this._getFilter(j);this.searchPageModule.resetToFilter(i);return i}},teardown:function(){this.el.remove();this.sandbox.restore();localStorage.removeItem("jira.issue.navigator.latest.search")}});test("FilterModule getFilterById for system filter",function(){var h=this.filterModule.getFilterById("-2");var j=this.sandbox.spy();h.done(j);equal(1,j.callCount);var i=j.args[0][0];equal("-2",i.getId());equal("reporter = currentUser() ORDER BY createdDate DESC",i.getJql());ok(i.getIsValid(),"The filter is valid.")});test("FilterModule getFilterById for favourite filter",function(){var h=this.filterModule.getFilterById("10001");var j=this.sandbox.spy();h.done(j);equal(1,j.callCount);var i=j.args[0][0];equal("10001",i.getId());equal("project = TST",i.getJql());ok(i.getIsValid(),"The filter is valid.")});test("FilterModule getFilterById for unknown filter",function(){var i={id:"unknown",jql:"this is a chunk of jql"};this.server.respondWith("GET",new RegExp(b.Models.Filter.prototype.root),[200,{"Content-Type":"application/json"},JSON.stringify(i)]);var h=this.filterModule.getFilterById("unknown");var k=this.sandbox.spy();h.done(k);this.server.respond();equal(1,k.callCount);var j=k.args[0][0];equal("unknown",j.getId());equal("this is a chunk of jql",j.getJql());ok(j.getIsValid(),"The filter is valid.")});test("FilterModel save updates filter collection",function(){var j="project = HSP and assignee = currentUser()";var i=this._selectFilter(10001);var h=i.toJSON();h.jql=j;this.server.respondWith("PUT",i.url(),[200,{"Content-Type":"application/json"},JSON.stringify(h)]);i.saveFilter(j);this.server.respond();equal(j,i.getJql());equal(j,this._getFilter(10001).getJql())});test("getFilterById() returns invalid filter if private",function(){this.server.respondWith([400,{},""]);var i=this.filterModule.getFilterById("1");var h=this.sandbox.spy();i.fail(h);i.fail(function(j){ok(!j.getIsValid())});this.server.respond();ok(h.called)});test("should raise an event when filters are removed",function(){var h=sinon.spy();this.filterModule.on("filterRemoved",h);this.filterModule.filtersComponent.trigger("filterRemoved",{filterId:1});equal(h.callCount,1,"the number of times onFilterRemoved is called")});test("should raise an event when filters are unfavourited",function(){var h=sinon.spy();this.filterModule.on("filterUnfavourited",h);this.filterModule.filtersComponent.trigger("filterUnfavourited",{filterId:1});equal(h.callCount,1,"the number of times onFilterUnfavourited is called")});test("should reset the search to the selected filter when a filter is selected",function(){sinon.stub(this.searchPageModule,"resetToFilter");this.filterModule.filtersComponent.trigger("filterSelected",1);equal(this.searchPageModule.resetToFilter.callCount,1,"resetToFilter is called once");ok(this.searchPageModule.resetToFilter.calledWith(1),"resetToFilter is called with the right filter")});test("should clear the search when no filter is selected",function(){sinon.stub(this.searchPageModule,"resetToBlank");this.filterModule.filtersComponent.trigger("filterSelected",null);equal(this.searchPageModule.resetToBlank.callCount,1,"resetToBlank is called once")});test("should change the active filter when a new filter is selected",function(){var h=this._selectFilter(10001);this.searchPageModule.set("filter",h);equal(this.filterModule.filterPanelModel.get("activeFilter").getId(),10001,"The new filter is saved in filterPanelModel")});test("Saving a new filter sets the latest search state",function(){var h=new b.Models.Filter({id:"-1"});this.filterModule.filtersComponent.trigger("newFilter",h);equal(this.searchPageModule.getState().filter,"-1","The saved filter is in the state")});test("Saving a new filter saves it as the latest search",function(){var h=this.searchPageModule;sinon.spy(h,"setSessionSearch");var i=new b.Models.Filter({id:"15",name:"a filter",favourite:true});this.filterModule.filtersComponent.trigger("newFilter",i);sinon.assert.calledOnce(h.setSessionSearch);sinon.assert.calledWith(h.setSessionSearch,i)});test("Loading the page with a filter already selected highlights it",function(){var h=this._selectFilter(10001);this.stub(this.filterModule.filterPanelModel,"set");this.filterModule.filtersComponent.trigger("list:render");sinon.assert.calledOnce(this.filterModule.filterPanelModel.set);sinon.assert.calledWith(this.filterModule.filterPanelModel.set,"activeFilter",h)});test("Saving a new filter respects dirty comment form",function(){var i=new b.Models.Filter({id:"-1"});var h=this.sandbox.stub(d,"request").withArgs("issueEditor:canDismissComment");var j=this.sandbox.spy(this.filterModule._searchPageModule,"setSessionSearch");h.returns(false);this.filterModule.filtersComponent.trigger("newFilter",i);equal(j.callCount,0,"Keeping a comment doesn't set new Session Search");h.returns(true);this.filterModule.filtersComponent.trigger("newFilter",i);equal(j.callCount,1,"Dismissing a comment sets new Session Search")});test("Saving a new filter marks it as active",function(){var h=new b.Models.Filter({id:"-1"});this.stub(this.filterModule.filtersComponent,"highlightFilter");this.filterModule.filtersComponent.trigger("savedFilter",h);sinon.assert.calledOnce(this.filterModule.filtersComponent.highlightFilter);sinon.assert.calledWith(this.filterModule.filtersComponent.highlightFilter,h)});test("Updating the header passes the values to the Header controller",function(){this.stub(this.filterModule.filtersComponent,"updateFilterHeader");this.filterModule.updateFilterHeader({isEdited:true,isPendingSearch:true});sinon.assert.calledOnce(this.filterModule.filtersComponent.updateFilterHeader);sinon.assert.calledWith(this.filterModule.filtersComponent.updateFilterHeader,{isEdited:true,isDirty:true})});test("Updating the header passes the default 'false' values to the Header controller",function(){this.stub(this.filterModule.filtersComponent,"updateFilterHeader");this.filterModule.updateFilterHeader();sinon.assert.calledOnce(this.filterModule.filtersComponent.updateFilterHeader);sinon.assert.calledWith(this.filterModule.filtersComponent.updateFilterHeader,{isEdited:false,isDirty:false})})});