define('jira/issues/search/legacyissuenavigator', [
    'jira/data/session-storage',
    'jira/util/browser',
    'jquery'
], function(
    SessionStorage,
    Browser,
    jQuery
) {
    "use strict";

    /**
     * Represents an the Issue Navigator page.  This class should be used to retrieve information from the
     * issue navigator such as the currently selected row, currently selected issue key and so on.
     *
     * @deprecated should all be superceded by {@link JIRA.Issues.Api}.
     * @todo TF-711 remove entirely.
     * @exports jira/issuenavigator/issue-navigator
     * @namespace JIRA.IssueNavigator
     */
    var IssueNavigator = {

        /**
         * Links the old IssueNavigator calls to the new JIRA.Issues.Api calls. This function is needed because we cannot
         * just 'require' the AMD module because JIRA.Issue might not be initialized.
         */
        initialize: function() {
            IssueNavigator.isNavigator = function() {
                return JIRA.Issues.Api.issueIsVisible();
            };
        },

        /**
         * Checks if we are currently viewing the issue navigator.
         *
         * @return {Boolean} true if the current page is the issue navigator, false otherwise
         */
        isNavigator: jQuery.noop,

        /**
         * Sets a message to be displayed when the navigator has been reloaded
         *
         * @param {Object} [options={}]
         * @param {String} options.issueMsg
         * @param {String} options.issueId
         * @param {String} options.issueKey
         */
        setIssueUpdatedMsg: function (options) {

            options = options || {};

            var issueMsg = options.issueMsg;
            var issueId = options.issueId;
            var issueKey = options.issueKey;

            if (!issueId) {
                issueId = this.getSelectedIssueId();
                issueKey = this.getSelectedIssueKey();
            }

            if (issueId) {
                SessionStorage.setItem('selectedIssueId', issueId);
            }

            if (issueKey) {
                SessionStorage.setItem('selectedIssueKey', issueKey);
            }

            if (issueMsg) {
                SessionStorage.setItem('selectedIssueMsg', issueMsg);
            }
        },

        /**
         * Reloads the issue navigator
         */
        reload: function () {
            Browser.reloadViaWindowLocation();
        },

        /**
         * Checks if any row is currently selected on the issue navigator. This can be the case for
         * an empty searchr, or if keyboard shortcuts are disabled.
         *
         * @return {Boolean} true if a selected issue row exists, false otherwise
         */
        isRowSelected: function() {
            return IssueNavigator.get$focusedRow().length !== 0;
        },

        /**
         * Returns a jQuery wrapped object representing the currently selected issue row.
         *
         * @return {jQuery} the jQuery wrapped issue row representing the currently selected row
         */
        get$focusedRow: function() {
            return jQuery("#issuetable tr.issuerow.focused");
        },

        /**
         * Returns the issue key for the currently selected row.
         *
         * @return {String} The issue key for the currently focused row or undefined if none exists.
         */
        getSelectedIssueKey: function() {
            var $focusedRow = IssueNavigator.get$focusedRow();
            if ($focusedRow.length !== 0) {
                return $focusedRow.attr("data-issuekey");
            }
            return undefined;
        },

        /**
         * Returns the issue id for the currently selected row.
         *
         * @return {String} The issue id for the currently focused row or undefined if none exists.
         */
        getSelectedIssueId: function() {
            return IssueNavigator.get$focusedRow().attr("rel");
        }
    };

    return IssueNavigator;
});
