(function(require) {
    "use strict";

    var jQuery = require("jquery");
    var Backbone = require("backbone");
    var _ = require("underscore");
    var KeyboardShortcut = require("jira/ajs/keyboardshortcut/keyboard-shortcut");
    var Meta = require("jira/util/data/meta");

    // Prevent escape key from cancelling XHR requests in FF
    jQuery(document).on('keydown', function(e) {
        if (e.which === 27) e.preventDefault();
    });

    jQuery(function() {

        JIRA.Issues.Application.start({
            showReturnToSearchOnError: function() {
                return JIRA.Issues.LayoutPreferenceManager.getPreferredLayoutKey() !== "split-view";
            },
            useLog: Meta.get("dev-mode") === true
        });

        /**
         * Create all our Backbone stuff
         */
        JIRA.Issues.GlobalIssueNavCreator.create(jQuery(document), JIRA.Issues.GlobalIssueNavCreator.readInitialData());

        Backbone.history.start({
            root: JIRA.Issues.IssueNavRouter.getBackboneRoot(),
            pushState: true
        });

        // Workaround for Chrome bug firing a null popstate event on page load.
        // Backbone should fix this!
        // @see http://code.google.com/p/chromium/issues/detail?id=63040
        // @see also JRADEV-14804
        if (jQuery.browser.webkit) {
            JIRA.Issues.ignorePopState = true;
            window.addEventListener('load', function() {
                _.defer(function() {
                    JIRA.Issues.ignorePopState = false;
                });
            });
        }

        KeyboardShortcut.addIgnoreCondition(function(e, key, ctx) {
            return ctx === "issueaction" && JIRA.Issues.Api.isCurrentlyLoadingIssue();
        });

        /*
         * Some shenanigans to get get table to resize with window gracefully. Sets the width of the issue navigator results
         * wrapper. Keeps the right hand page elements within the browser view when the results table is wider than the browser view.
         */
        var bodyMinWidth = parseInt(jQuery('body').css('minWidth'), 10);
        jQuery(document).bind('resultsWidthChanged', function() {
            var $contained = jQuery('.contained-content');
            var $containedParent = $contained.parent();

            if ($contained.length > 0) {
                var containedLeft = $contained.offset().left;
                var target = Math.max(window.innerWidth, bodyMinWidth) - containedLeft;
                var targetPct = target / $containedParent.width() * 100;
                if (targetPct < 100) {
                    $contained.css('width', targetPct + '%');
                } else {
                    $contained.css('width', '');
                }
                jQuery(document).trigger('issueNavWidthChanged');
            }
        });

        // Trigger the event on page load to make sure the controls are visible.
        jQuery(document).trigger("resultsWidthChanged");

        JIRA.Issues.onVerticalResize(function() {
            jQuery.event.trigger("updateOffsets.popout");
        });

        // When switching layouts we need to update the height of sidebar
        JIRA.bind(JIRA.Events.LAYOUT_RENDERED, function() {
            _.defer(function() {
                jQuery.event.trigger("updateOffsets.popout");
            });
        });
    });

}(window.require));
